/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.modules;

import com.avaya.collaboration.authorization.AccessTokenProvider;
import com.avaya.collaboration.authorization.ClientParams;
import com.avaya.collaboration.authorization.http.HttpClientProvider;
import com.avaya.collaboration.authorization.http.HttpClientProviderImpl;
import com.avaya.collaboration.authorization.impl.AccessTokenProviderImpl;
import com.avaya.collaboration.authorization.modules.ClientKeyStore;
import com.avaya.collaboration.authorization.modules.ClientTrustStore;
import com.avaya.collaboration.authorization.modules.KeyProvider;
import com.avaya.collaboration.authorization.modules.SslProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.google.inject.throwingproviders.CheckedProvides;
import com.google.inject.throwingproviders.ThrowingProviderBinder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.RSAPrivateKey;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class ClientModule
extends AbstractModule {
    private KeyManagerFactory keyManagerFactoryInstance;
    private TrustManagerFactory trustManagerFactoryInstance;
    private ClientParams clientParams;

    public ClientModule(ClientParams clientParams) throws IOException, GeneralSecurityException {
        this.clientParams = clientParams;
        this.initKeyManager();
        this.initTrustManager();
    }

    private void initKeyManager() throws IOException, GeneralSecurityException {
        this.keyManagerFactoryInstance = KeyManagerFactory.getInstance("SunX509");
        this.keyManagerFactoryInstance.init(this.clientParams.getKeyStore(), this.clientParams.getKeyStorePassword().toCharArray());
    }

    private void initTrustManager() throws IOException, GeneralSecurityException {
        this.trustManagerFactoryInstance = TrustManagerFactory.getInstance("SunX509");
        this.trustManagerFactoryInstance.init(this.clientParams.getTrustStore());
    }

    @Override
    protected void configure() {
        this.install(ThrowingProviderBinder.forModule(this));
        this.bindConstant().annotatedWith(Names.named("tokenEndpoint")).to(this.clientParams.getTokenEndpoint());
        this.bindConstant().annotatedWith(Names.named("keyStorePassword")).to(this.clientParams.getKeyStorePassword());
        this.bindConstant().annotatedWith(Names.named("clientId")).to(this.clientParams.getClientId());
        this.bindConstant().annotatedWith(Names.named("privateKeyAlias")).to(this.clientParams.getKeyAlias());
        this.bind(HttpClientProvider.class).to(HttpClientProviderImpl.class);
        this.bind(AccessTokenProvider.class).to(AccessTokenProviderImpl.class);
    }

    @Provides
    @ClientKeyStore
    KeyStore provideKeyStore() {
        return this.clientParams.getKeyStore();
    }

    @Provides
    @ClientTrustStore
    KeyStore provideTrustStore() {
        return this.clientParams.getTrustStore();
    }

    @Singleton
    @CheckedProvides(value=SslProvider.class)
    SSLContext provideSslContext() throws KeyManagementException, NoSuchAlgorithmException {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextInt();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagerFactoryInstance.getKeyManagers(), this.trustManagerFactoryInstance.getTrustManagers(), secureRandom);
        return sslContext;
    }

    @CheckedProvides(value=KeyProvider.class)
    RSAPrivateKey provideProvateKey() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return (RSAPrivateKey)this.clientParams.getKeyStore().getKey(this.clientParams.getKeyAlias(), this.clientParams.getKeyStorePassword().toCharArray());
    }
}

