/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import com.avaya.common.logging.helper.EventCode;
import com.avaya.common.logging.helper.ParameterCoder;
import com.avaya.common.logging.helper.PluginResource;
import com.avaya.common.logging.helper.ResourceBundleLoader;
import com.avaya.common.logging.helper.ResourceKey;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.helpers.LogLog;

public class EventMsg {
    protected EventCode mEventCode = null;
    protected Object[] mArgumentList = null;

    public EventMsg(EventCode eventCode) {
        if (eventCode == null) {
            throw new NullPointerException();
        }
        this.mEventCode = eventCode;
    }

    public EventMsg(EventCode eventCode, Object ... objectArray) {
        if (eventCode == null) {
            throw new NullPointerException();
        }
        this.mEventCode = eventCode;
        this.mArgumentList = objectArray;
        for (int i = 0; i < this.mArgumentList.length; ++i) {
            if (this.mArgumentList[i] instanceof ResourceKey || this.mArgumentList[i] instanceof Date || this.mArgumentList[i] instanceof Number || this.mArgumentList[i] instanceof String) continue;
            this.mArgumentList[i] = this.mArgumentList[i] != null ? this.mArgumentList[i].toString() : "";
        }
    }

    private String getResourceKeyValue(String string) {
        String string2;
        block6: {
            String string3 = this.mEventCode.mNameSpace + "." + "EventCodes";
            string2 = "";
            ResourceBundle resourceBundle = null;
            try {
                FileInputStream fileInputStream;
                block5: {
                    fileInputStream = null;
                    try {
                        ResourceBundleLoader resourceBundleLoader = new ResourceBundleLoader();
                        resourceBundle = resourceBundleLoader.load(string3);
                    }
                    catch (MissingResourceException missingResourceException) {
                        PluginResource pluginResource = new PluginResource();
                        fileInputStream = pluginResource.getPropertiesFile(Locale.getDefault().toString(), this.mEventCode.mNameSpace);
                        if (fileInputStream == null) break block5;
                        resourceBundle = new PropertyResourceBundle(fileInputStream);
                    }
                }
                string2 = resourceBundle.getString(string);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                LogLog.error((String)("No object can be found for the resource key= " + string));
                if (string == null) break block6;
                string2 = string;
            }
        }
        return string2;
    }

    public Object[] getArguments() {
        return this.mArgumentList;
    }

    public EventCode getEventCode() {
        return this.mEventCode;
    }

    public String getParameterMsg() {
        return ParameterCoder.decodeParameters(this.mArgumentList);
    }

    public String getDecodedMsg() {
        String string = null;
        Object[] objectArray = new Object[100];
        if (this.mArgumentList != null) {
            for (int i = 0; i < this.mArgumentList.length; ++i) {
                Object object;
                if (this.mArgumentList[i] instanceof ResourceKey) {
                    object = ((ResourceKey)this.mArgumentList[i]).getValue();
                    objectArray[i] = this.getResourceKeyValue((String)object);
                    continue;
                }
                if (this.mArgumentList[i] instanceof Date) {
                    object = new SimpleDateFormat("@yyyy-MM-dd/HH:mm:ss.SSS").format((Date)this.mArgumentList[i]);
                    if (object == null) continue;
                    objectArray[i] = object;
                    continue;
                }
                if (this.mArgumentList[i] instanceof Number) {
                    if (this.mArgumentList[i].toString().contains(".")) {
                        object = new DecimalFormat();
                        ((DecimalFormat)object).setGroupingUsed(false);
                        ((DecimalFormat)object).applyPattern("#.###E0");
                        objectArray[i] = Double.valueOf(((Format)object).format(this.mArgumentList[i]));
                        continue;
                    }
                    object = NumberFormat.getInstance();
                    ((NumberFormat)object).setGroupingUsed(false);
                    objectArray[i] = Long.valueOf(((Format)object).format(this.mArgumentList[i]));
                    continue;
                }
                if (!(this.mArgumentList[i] instanceof String)) continue;
                objectArray[i] = this.mArgumentList[i];
            }
        } else {
            objectArray = null;
        }
        try {
            string = MessageFormat.format(this.mEventCode.getEventMsgString(), objectArray);
            if (string == null) {
                LogLog.error((String)"Decoded message is null. So get parameter message instead.");
                string = this.getParameterMsg();
            }
        }
        catch (Exception exception) {
            LogLog.error((String)"Error in decoding message. So get parameter message instead.");
            string = this.getParameterMsg();
        }
        return string;
    }

    public String toString() {
        return this.getDecodedMsg();
    }
}

