/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

import com.avaya.zephyr.common.testutils.deencapsulation.ClassLoad;
import com.avaya.zephyr.common.testutils.deencapsulation.DefaultValues;
import com.avaya.zephyr.common.testutils.deencapsulation.ParameterReflection;
import com.avaya.zephyr.common.testutils.deencapsulation.Utilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ConstructorReflection {
    public static <T> T newInstance(Class<T> aClass, Class<?>[] parameterTypes, Object ... initArgs) {
        Constructor<T> constructor = ConstructorReflection.findSpecifiedConstructor(aClass, parameterTypes);
        return ConstructorReflection.invoke(constructor, initArgs);
    }

    private static <T> Constructor<T> findSpecifiedConstructor(Class<?> theClass, Class<?>[] paramTypes) {
        for (Constructor<?> declaredConstructor : theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParameterTypes = declaredConstructor.getParameterTypes();
            int firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParameterTypes, paramTypes);
            if (firstRealParameter < 0 || !ParameterReflection.matchesParameterTypes(declaredParameterTypes, paramTypes, firstRealParameter)) continue;
            return declaredConstructor;
        }
        String paramTypesDesc = ParameterReflection.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified constructor not found: " + theClass.getSimpleName() + paramTypesDesc);
    }

    public static <T> T invoke(Constructor<T> constructor, Object ... initArgs) {
        Utilities.ensureThatMemberIsAccessible(constructor);
        Object[] args = initArgs != null ? initArgs : ConstructorReflection.getDefaultParameterValues(constructor);
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static Object[] getDefaultParameterValues(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int numParameters = parameterTypes.length;
        Object[] defaultArgs = new Object[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            Class<?> paramType = parameterTypes[i];
            defaultArgs[i] = DefaultValues.computeForType(paramType);
        }
        return defaultArgs;
    }

    public static <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... initArgs) {
        Class theClass = ClassLoad.loadClass(className);
        return ConstructorReflection.newInstance(theClass, parameterTypes, initArgs);
    }

    public static <T> T newInstance(String className, Object ... nonNullArgs) {
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(nonNullArgs);
        Class theClass = ClassLoad.loadClass(className);
        Constructor<T> constructor = ConstructorReflection.findCompatibleConstructor(theClass, argTypes);
        return ConstructorReflection.invoke(constructor, nonNullArgs);
    }

    private static <T> Constructor<T> findCompatibleConstructor(Class<?> theClass, Class<?>[] argTypes) {
        Constructor<?>[] declaredConstructors;
        Constructor<?> found = null;
        Class<?>[] foundParameters = null;
        for (Constructor<?> declaredConstructor : declaredConstructors = theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParamTypes = declaredConstructor.getParameterTypes();
            int firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParamTypes, argTypes);
            if (firstRealParameter < 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes, firstRealParameter) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes, firstRealParameter) || found != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParameters)) continue;
            found = declaredConstructor;
            foundParameters = declaredParamTypes;
        }
        if (found != null) {
            return found;
        }
        Class<?> declaringClass = theClass.getDeclaringClass();
        Class<?>[] paramTypes = declaredConstructors[0].getParameterTypes();
        if (paramTypes[0] == declaringClass && paramTypes.length > argTypes.length) {
            throw new IllegalArgumentException("Invalid instantiation of inner class; use newInnerInstance instead");
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible constructor found: " + theClass.getSimpleName() + argTypesDesc);
    }

    public static <T> T newInstance(Class<? extends T> aClass, Object ... nonNullArgs) {
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(nonNullArgs);
        Constructor<T> constructor = ConstructorReflection.findCompatibleConstructor(aClass, argTypes);
        return ConstructorReflection.invoke(constructor, nonNullArgs);
    }

    public static <T> T newInstance(Class<T> aClass) {
        return ConstructorReflection.newInstance(aClass, (Object[])ParameterReflection.NO_PARAMETERS);
    }

    public static <T> T newInnerInstance(Class<? extends T> innerClass, Object outerInstance, Object ... nonNullArgs) {
        Object[] initArgs = ParameterReflection.argumentsWithExtraFirstValue(nonNullArgs, outerInstance);
        return ConstructorReflection.newInstance(innerClass, initArgs);
    }

    public static <T> T newInnerInstance(String innerClassName, Object outerInstance, Object ... nonNullArgs) {
        String className = outerInstance.getClass().getName() + '$' + innerClassName;
        Class innerClass = ClassLoad.loadClass(className);
        return ConstructorReflection.newInnerInstance(innerClass, outerInstance, nonNullArgs);
    }
}

