/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 ****************************************************************************/
package com.avaya.zephyr.sdk.authorization.samples.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.avaya.zephyr.sdk.authorization.samples.client.interceptors.AccessTokenInterceptor;
import com.avaya.zephyr.sdk.authorization.samples.client.interceptors.AuthorizationCodeInterceptor;

/**
 * Spring Interceptor configuration to add both the {@link AuthorizationCodeInterceptor} and
 * {@link AccessTokenInterceptor} to the registry. These interceptors are called
 * before processing every HTTP request.
 *
 * @author Avaya
 */
@Configuration
public class InterceptorConfig extends WebMvcConfigurerAdapter
{
    @Autowired
    private Environment env;

    @Bean
    AccessTokenInterceptor getAccessTokenInterceptor()
    {
        return new AccessTokenInterceptor(env);
    }

    @Bean
    AuthorizationCodeInterceptor getAuthorizationCodeInterceptor()
    {
        return new AuthorizationCodeInterceptor(env);
    }

    /*
     * Every request is first intercepted by the AuthorizationCodeInterceptor
     * and then by the AccessTokenInterceptor
     */
    @Override
    public void addInterceptors(final InterceptorRegistry registry)
    {
        registry.addInterceptor(getAuthorizationCodeInterceptor());
        registry.addInterceptor(getAccessTokenInterceptor());
    }
}