/*****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya  Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/

package com.avaya.collaboration.authorization.impl;

import java.util.Arrays;
import java.util.List;

import com.avaya.collaboration.authorization.AccessToken;
import com.google.gson.annotations.SerializedName;
/**
 * Implementation of the {@link AccessToken} interface.
 *
 * @author Avaya
 */
public final class AccessTokenImpl implements AccessToken
{
    private String accessToken;
    private Integer expiresIn;
    private String scope;
    private String subject;
    private String tokenType;

    @Override
    public String getSubject()
    {
        return subject;
    }

    public void setSubject(final String subject)
    {
        this.subject = subject;
    }

    @Override
    @SerializedName("access_token")
    public String toString()
    {
        return accessToken;
    }

    public void setToken(final String accessToken)
    {
        this.accessToken = accessToken;
    }

    @Override
    public int getExpiresIn()
    {
        return expiresIn;
    }

    public void setExpiresIn(final Integer expiresIn)
    {
        this.expiresIn = expiresIn;
    }

    @Override
    public List<String> getScopes()
    {
        return Arrays.asList(scope.split("\\s* \\s*"));
    }

    public void setScopes(final String scope)
    {
        this.scope = scope;
    }

    @Override
    public String getTokenType()
    {
        return tokenType;
    }

    public void setTokenType(String tokenType)
    {
        this.tokenType = tokenType;
    }
}