/*****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya  Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/

package com.avaya.collaboration.authorization;

import java.security.KeyStore;

/**
 * 
 * Holds Authorization and Keystore information specific to the client
 * 
 * @author Avaya
 *
 * @since 3.2
 */
public final class ClientParams
{
    private String clientId;
    private String tokenEndpoint;

    private KeyStore keyStore;
    private String keyStorePassword;
    private String keyAlias;

    private KeyStore trustStore;

    public String getTokenEndpoint()
    {
        return tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint)
    {
        this.tokenEndpoint = tokenEndpoint;
    }

    public KeyStore getKeyStore()
    {
        return keyStore;
    }

    public void setKeyStore(KeyStore keyStore)
    {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword()
    {
        return keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword)
    {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyAlias()
    {
        return keyAlias;
    }

    public void setKeyAlias(String keyAlias)
    {
        this.keyAlias = keyAlias;
    }

    public KeyStore getTrustStore()
    {
        return trustStore;
    }

    public void setTrustStore(KeyStore trustStore)
    {
        this.trustStore = trustStore;
    }

    public String getClientId()
    {
        return clientId;
    }

    public void setClientId(String clientId)
    {
        this.clientId = clientId;
    }
}
