package com.avaya.zephyr.sdk.authorization.samples.client.controller;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import com.avaya.zephyr.sdk.authorization.samples.client.model.Task;
import com.avaya.zephyr.sdk.authorization.samples.client.repository.TaskRepository;

@RunWith(MockitoJUnitRunner.class)
public class TaskHandlerTest
{
    TaskHandler classToTest;

    @Mock
    TaskRepository mockTaskRepository;

    @Mock
    Task mockTask;

    Task mockTask2;

    @Before
    public void setUp() throws Exception
    {
        classToTest = new TaskHandler(mockTaskRepository);

        mockTask2 = new Task();
        mockTask2.setChecked(true);
        mockTask2.setDescription("Task Description");
        mockTask2.setId(1);
    }

    @Test
    public void testFindTasks()
    {
        Mockito.when(mockTaskRepository.findAll()).thenReturn(Arrays.asList(mockTask, mockTask2));

        final List<Task> allTasks = classToTest.findTasks();
        assertTrue(allTasks.size() == 2);
    }

    @Test
    public void testAddTask()
    {
        Mockito.when(mockTaskRepository.saveAndFlush(Mockito.any(Task.class))).thenReturn(mockTask2);

        final Task addedTask = classToTest.addTask(mockTask2);
        assertTrue(addedTask.getDescription() == "Task Description");
        assertTrue(addedTask.isChecked());
    }

    @Test
    public void testUpdateTask()
    {
        Mockito.when(mockTaskRepository.saveAndFlush(Mockito.any(Task.class))).thenReturn(mockTask2);

        mockTask2.setChecked(false);
        final Task updatedTask = classToTest.updateTask(mockTask2, 1);
        assertTrue(updatedTask.getDescription() == "Task Description");
        assertFalse(updatedTask.isChecked());
    }

    @Test
    public void testDeleteTask()
    {
        classToTest.deleteTask(1);
    }
}
