/*****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya  Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/

package com.avaya.collaboration.authorization;

/**
 * Indicates HTTP error responses propagated by the Authorization Helper APIs. The Authorization Service may deny token requests for
 * multiple reasons - for example, the scope requested by an Authorization Client might not have sufficient privileges or the user's
 * credentials might not be valid. The Authorization Service denotes these denials in the form of HTTP error responses. This exception wraps
 * such responses and propagates them to the client.
 *
 * Check SampleAuthorizationClient.getAccessTokenForUser() for an example of its usage.
 *
 * @author Avaya
 * @since 3.2
 */
public class HttpResponseException extends Exception
{
    private static final long serialVersionUID = -5273952041189673405L;

    private final int statusCode;

    private final String statusMessage;

    public HttpResponseException(final int statusCode, final String message)
    {
        super(message);
        this.statusCode = statusCode;
        this.statusMessage = message;
    }

    /**
     * Returns the HTTP response status code
     *
     * @return HTTP response status code
     */
    public int getStatusCode()
    {
        return statusCode;
    }

    /**
     * Returns the HTTP response status message
     *
     * @return HTTP response status message
     */
    public String getStatusMessage()
    {
        return statusMessage;
    }
}
