(function(angular) {
	var AppController = function($scope, Task, $location, $cookies, $http) {

		if ($cookies.getObject('UserSession')) 
		{
			$scope.username = JSON.parse($cookies.getObject('UserSession')).currentUser.username;
		}

		Task.query(function(response) {
			$scope.tasks = response ? response : [];
		});

		$scope.addTask = function(description) {
			new Task({
				description: description,
				checked: false
			}).$save(function(task) {
				$scope.tasks.push(task);
			});
			$scope.newTask = "";
		};

		$scope.updateTask = function(task) {
			task.$update();
		};

		$scope.deleteTask = function(task) {
			task.$remove(function() {
				$scope.tasks.splice($scope.tasks.indexOf(task), 1);
			});
		};

		$scope.logout = function() {
			$cookies.remove('UserSession');
			location.reload();
		};
	};

	AppController.$inject = ['$scope', 'Task', '$location', '$cookies', '$http'];
	angular.module("myApp.controllers").controller("AppController", AppController);
}(angular));