/*****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya  Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/

package com.avaya.collaboration.authorization.sample;

/**
 * <pre>
 * 
 *   Sample code to get an access token using AuthorizationClientHelper. <br>
 *   
 *   Use AuthorizationClientHelper.Builder() to build an instance of the helper.
 *   Use instance.getAccessToken() to obtain an AccessToken for a client.<br>
 *   Use instance.getAccessTokenForUser(userName, userPass) to obtain an AccessToken for a user. <br>
 *   
 *   
 *   AccessToken.toString() returns the token string.
 *   AccessToken.getExpiresIn() returns the token's expiry in seconds. This can be used to cache the token for a specific lease time.<br>
 *   AccessToken.getScopes() returns a list of scopes associated with the token. <br>
 *  
 * import java.security.KeyStore;
 * 
 * import javax.annotation.PostConstruct;
 * import javax.annotation.PreDestroy;
 * import javax.inject.Inject;
 * import javax.inject.Singleton;
 * 
 * {@literal @}Singleton
 * public class SampleAuthorizationClient
 * {
 *     private AuthorizationClientHelper authzClientHelper;
 *     private KeyStore clientKeyStore;
 *     private KeyStore clientTrustStore;
 * 
 *     {@literal @}Inject
 *     public SampleAuthorizationClient(KeyStore clientKeyStore, KeyStore clientTrustStore)
 *     {
 *         this.clientKeyStore = clientKeyStore;
 *         this.clientTrustStore = clientTrustStore;
 *     }
 * 
 *     {@literal @}PostConstruct
 *     public void initialize() throws AuthorizationHelperException
 *     {
 *         authzClientHelper = new AuthorizationClientHelper.Builder()
 *                 .tokenEndpoint("https://IP/services/AuthorizationService/token")
 *                 .clientIdentifier("client_id")
 *                 .keyStore(clientKeyStore, "keyStore_password", "key_alias")
 *                 .trustStore(clientTrustStore)
 *                 .build();
 *     }
 * 
 *     public void getAccessToken()
 *     {
 *         AccessToken aToken = null;
 *         try
 *         {
 *             aToken = authzClientHelper.getAccessToken();
 *             if (aToken != null)
 *             {
 *                 // Use the token to make a resource request
 *             }
 *         }
 *         catch (HttpResponseException e)
 *         {
 *             // This indicates any HTTP response received by the helper
 *             // other than a success
 *         }
 *         catch (AuthorizationHelperException e)
 *         {
 *             // This indicates any error conditions in the helper
 *         }
 *     }
 * 
 *     {@literal @}PreDestroy
 *     public void shutDown() throws AuthorizationHelperException
 *     {
 *         authzClientHelper.shutdown();
 *     }
 * }
 * 
 * </pre>
 */

public final class SampleAuthorizationClient // NOPMD
{
    private SampleAuthorizationClient()
    {
    }
}
