/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Subscription;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionManager
implements DisposableBean {
    private final ConcurrentMap<String, Subscription> subscriptionByProducer = new ConcurrentHashMap();
    private final AtomicBoolean isDestroying = new AtomicBoolean(false);

    public void associate(String producerId, Subscription subscription) {
        this.checkState();
        this.subscriptionByProducer.put(producerId, subscription);
    }

    public Subscription getSubscription(String producerId) {
        return (Subscription)this.subscriptionByProducer.get(producerId);
    }

    public Subscription dissociate(String producerId) {
        this.checkState();
        return (Subscription)this.subscriptionByProducer.remove(producerId);
    }

    public Set<String> getAllSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptionByProducer.keySet());
    }

    public void destroy() {
        this.isDestroying.set(true);
        this.subscriptionByProducer.values().forEach(s -> s.getRtdDataProvider().disconnect());
        this.subscriptionByProducer.clear();
    }

    private void checkState() {
        if (this.isDestroying.get()) {
            throw new IllegalStateException("Subscription manager shutted down");
        }
    }
}

