/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient;

import com.avaya.oceanalytics.openinterface.websocketclient.encryption.Base64StringEncryptor;
import com.avaya.oceanalytics.openinterface.websocketclient.encryption.StringEncryptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ApplicationConfig {
    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public StringEncryptor encryptor() {
        return new Base64StringEncryptor();
    }

    @Bean
    public HttpClient httpClient(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        return HttpClients.custom().setSSLHostnameVerifier(hostnameVerifier).setSSLContext(sslContext).build();
    }

    @Bean
    public HttpComponentsClientHttpRequestFactory httpRequestFactory(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClient);
        return requestFactory;
    }

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory httpRequestFactory) {
        return new RestTemplate(httpRequestFactory);
    }

    @Bean
    public SSLContext sslContext() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        org.apache.http.conn.ssl.TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
    }

    @Bean
    public HostnameVerifier hostnameVerifier() {
        return new NoopHostnameVerifier();
    }
}

