/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Subscription;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionRedirectRequest;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionRedirectRequestType;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionProducer.class);
    private final ObjectMapper mapper;
    private final RealtimeDataProvider rtdProvider;

    @Autowired
    public SubscriptionProducer(ObjectMapper mapper, RealtimeDataProvider rtdProvider) {
        this.mapper = mapper;
        this.rtdProvider = rtdProvider;
    }

    public void sendPumpupRequest(String authToken, Subscription subscription) {
        this.sendRequest(authToken, subscription, SubscriptionRedirectRequestType.SUBSCRIPTIONREDIRECT);
    }

    public void sendUnsubscribeRequest(String authToken, Subscription subscription) {
        this.sendRequest(authToken, subscription, SubscriptionRedirectRequestType.UNSUBSCRIPTIONREDIRECT);
    }

    public void sendSubscribeRequest(String authToken, Subscription subscription) {
        this.sendRequest(authToken, subscription, SubscriptionRedirectRequestType.SUBSCRIPTIONREDIRECT);
    }

    public void sendRequest(String authToken, Subscription subscription, SubscriptionRedirectRequestType requestType) {
        SubscriptionRedirectRequest request = new SubscriptionRedirectRequest();
        request.setAuthorization(authToken);
        request.setEventName(requestType.toString());
        request.setGuid(subscription.getGuid());
        request.setProducer(subscription.getProducer());
        request.setSource(subscription.getSource());
        request.setTransport(subscription.getTransport());
        request.setVersion("3.5");
        request.setEndpoint(subscription.getEndpoint());
        request.setProducerId(subscription.getProducerId());
        request.setStreamType(subscription.getStreamType());
        request.setSourceId(subscription.getSourceId());
        try {
            this.rtdProvider.send(this.mapper.writeValueAsString((Object)request));
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while sending subscription redirect request", (Throwable)e);
        }
    }
}

