/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient;

import com.avaya.oceanalytics.openinterface.websocketclient.RestClientException;
import com.avaya.oceanalytics.openinterface.websocketclient.auth.AuthenticationResponse;
import com.avaya.oceanalytics.openinterface.websocketclient.auth.AuthenticationToken;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Dictionary;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.DimensionData;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Producer;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Source;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionRequest;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClient.class);
    private static final String LOG_RECEIVE_RESPONSE = "Received response <- {}";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8443;
    private static final int MAX_PORT_VALUE = 65535;
    private static final String SCHEME_HTTPS = "https";
    private static final String PS_DOMAIN = "orca-streams-rest";
    private static final String P_LOGIN = "/users/login";
    private static final String QP_USERNAME = "username";
    private static final String QP_PASSWORD = "password";
    private static final String PS_SOURCES = "sources";
    private static final String PS_PRODUCERS = "producers";
    private static final String PS_SUBSCRIPTIONS = "subscriptions";
    private static final String PS_DICTIONARIES = "dictionaries";
    private static final String PS_ADMIN_DATA = "Admin_Admin_3.5";
    private static final String PS_DIM_DATA = "dimdata";
    private static final String PS_DATA_TYPE = "dataType";
    private final String hostname;
    private final Integer port;
    private final RestTemplate restTemplate;

    @Autowired
    public RestClient(RestTemplate restTemplate, @Value(value="${avaya.oceanalytics.stream-server.hostname:localhost}") String hostname, @Value(value="${avaya.oceanalytics.stream-server.port:8443}") Integer port) {
        this.restTemplate = restTemplate;
        this.hostname = StringUtils.isBlank((CharSequence)hostname) ? DEFAULT_HOST : hostname;
        this.port = port == null || port < 0 || port > 65535 ? 8443 : port;
    }

    public AuthenticationToken authenticate(String username, String password) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).path(P_LOGIN).queryParam(QP_USERNAME, new Object[]{username}).queryParam(QP_PASSWORD, new Object[]{password}).toUriString();
        try {
            LOGGER.trace("Executing GET request -> {}", (Object)url);
            AuthenticationResponse response = (AuthenticationResponse)this.restTemplate.getForObject(url, AuthenticationResponse.class, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)response);
            Optional<AuthenticationResponse> opt = Optional.ofNullable(response);
            return opt.orElseThrow(Exception::new).getToken();
        }
        catch (Exception e) {
            LOGGER.error("Authentication failed", (Throwable)e);
            throw new RestClientException("Authentication request for '" + username + "' ends up with failure");
        }
    }

    public List<Source> getSources(String authToken) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).query("tenant=0").query("locale=en").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (List)responseEntity.getBody();
            }
            return new ArrayList<Source>();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve a list of sources", (Throwable)e);
            throw new RestClientException("Unable to retrieve a list of sources");
        }
    }

    public Source getSource(String authToken, String sourceId) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).query("tenant=0").query("locale=en").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (Source)responseEntity.getBody();
            }
            return new Source();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve a list of sources", (Throwable)e);
            throw new RestClientException("Unable to retrieve a list of sources");
        }
    }

    public List<Producer> getProducers(String authToken, String sourceId) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_PRODUCERS}).query("tenant=0").query("locale=en").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (List)responseEntity.getBody();
            }
            return new ArrayList<Producer>();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve a list of producers", (Throwable)e);
            throw new RestClientException("Unable to retrieve a list of producers");
        }
    }

    public Producer getProducer(String authToken, String sourceId, String producerId) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_PRODUCERS}).pathSegment(new String[]{producerId}).query("tenant=0").query("locale=en").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (Producer)responseEntity.getBody();
            }
            return new Producer();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve a list of producers", (Throwable)e);
            throw new RestClientException("Unable to retrieve a list of producers");
        }
    }

    public Dictionary getDictionary(String authToken, String sourceId, String producerId, String locale) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_PRODUCERS}).pathSegment(new String[]{producerId}).pathSegment(new String[]{PS_DICTIONARIES}).query("tenant=0").queryParam("locale", new Object[]{locale}).toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (Dictionary)responseEntity.getBody();
            }
            return new Dictionary();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve the dictionary ", (Throwable)e);
            throw new RestClientException("Unable to retrieve the dictionary.");
        }
    }

    public DimensionData getDimensionData(String authToken, String sourceId, String dimensionDataName) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_PRODUCERS}).pathSegment(new String[]{PS_ADMIN_DATA}).pathSegment(new String[]{PS_DIM_DATA}).pathSegment(new String[]{dimensionDataName}).pathSegment(new String[]{PS_DATA_TYPE}).pathSegment(new String[]{dimensionDataName}).query("tenant=0").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (DimensionData)responseEntity.getBody();
            }
            return new DimensionData();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve the dimension data ", (Throwable)e);
            throw new RestClientException("Unable to retrieve the dimension data.");
        }
    }

    public SubscriptionResponse subscribeForRealtimeData(String authToken, SubscriptionRequest request) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{request.getSourceId()}).pathSegment(new String[]{PS_PRODUCERS}).pathSegment(new String[]{request.getProducerId()}).pathSegment(new String[]{PS_SUBSCRIPTIONS}).toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing POST request -> {} with headers {}", (Object)url, (Object)headers);
            SubscriptionResponse response = (SubscriptionResponse)this.restTemplate.postForObject(url, (Object)new HttpEntity((Object)request, (MultiValueMap)headers), SubscriptionResponse.class, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)response);
            return response;
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to perform subscription:", (Throwable)e);
            if (HttpStatus.NOT_FOUND.equals((Object)e.getStatusCode())) {
                throw new RestClientException("Unable to perform subscription: either sourceId '" + request.getSourceId() + "' either producerId '" + request.getProducerId() + "' of both are invalid");
            }
            throw new RestClientException("Unable to perform subscription: " + e.getResponseBodyAsString());
        }
        catch (HttpServerErrorException | UnknownHttpStatusCodeException e) {
            LOGGER.error("Unable to perform subscription ", e);
            throw new RestClientException("Unable to perform subscription: " + e.getResponseBodyAsString());
        }
    }

    public List<SubscriptionResponse> getListOfSubscriptions(String authToken, String sourceId) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_SUBSCRIPTIONS}).query("tenant=0").toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing GET request -> {} with headers {}", (Object)url, (Object)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LOGGER.trace(LOG_RECEIVE_RESPONSE, (Object)responseEntity);
            if (responseEntity.getBody() != null) {
                return (List)responseEntity.getBody();
            }
            return new ArrayList<SubscriptionResponse>();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to retrieve a list of subscriptions", (Throwable)e);
            throw new RestClientException("Unable to retrieve a list of subscriptions");
        }
    }

    public void unsubscribeFromRealtimeData(String authToken, String sourceId, String producerId) {
        String url = this.getHttpUrl().pathSegment(new String[]{PS_DOMAIN}).pathSegment(new String[]{PS_SOURCES}).pathSegment(new String[]{sourceId}).pathSegment(new String[]{PS_PRODUCERS}).pathSegment(new String[]{producerId}).pathSegment(new String[]{PS_SUBSCRIPTIONS}).toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", authToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        try {
            LOGGER.trace("Executing DELETE request -> {} with headers {}", (Object)url, (Object)headers);
            this.restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Unable to perform unsubscription", (Throwable)e);
            throw new RestClientException("Unable to perform unsubscription: either sourceId '" + sourceId + "' either producerId '" + producerId + "' of both are invalid");
        }
    }

    private UriComponentsBuilder getHttpUrl() {
        return UriComponentsBuilder.newInstance().scheme(SCHEME_HTTPS).host(this.hostname).port(this.port.intValue());
    }
}

