/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.auth;

import com.avaya.oceanalytics.openinterface.websocketclient.encryption.StringEncryptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UserCredentials {
    private StringEncryptor encryptor;
    private String username;
    private String password;

    @Autowired
    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("username", (Object)this.username).append("password", (Object)this.password).build();
    }

    public int hashCode() {
        return new HashCodeBuilder(1, 3).append((Object)this.username).append((Object)this.getPassword()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserCredentials other = (UserCredentials)obj;
        return new EqualsBuilder().append((Object)this.username, (Object)other.username).append((Object)this.getPassword(), (Object)other.getPassword()).isEquals();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.encryptor != null ? this.encryptor.decrypt(this.password) : this.password;
    }

    public void setPassword(String password) {
        this.password = this.encryptor != null ? this.encryptor.encrypt(password) : password;
    }
}

