/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient;

import com.avaya.oceanalytics.openinterface.websocketclient.RestClient;
import com.avaya.oceanalytics.openinterface.websocketclient.RestClientException;
import com.avaya.oceanalytics.openinterface.websocketclient.auth.AuthenticationTokenCache;
import com.avaya.oceanalytics.openinterface.websocketclient.auth.UserCredentials;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Dictionary;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.DimensionData;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Filter;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Producer;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Source;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.StreamType;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.Subscription;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionManager;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionProducer;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionRequest;
import com.avaya.oceanalytics.openinterface.websocketclient.subscription.SubscriptionResponse;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataHandler;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProvider;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProviderException;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.SuppressibleRealtimeDataHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class ShellCommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommandHandler.class);
    private static final String ANNOUNCEMENT = "You are about to get realtime data from Avaya Analytics. Type something and press ENTER to return to prompt.";
    private final RestClient restClient;
    private final ObjectFactory<UserCredentials> credentialsFactory;
    private final AuthenticationTokenCache authTokenCache;
    private final SubscriptionManager manager;
    private final SubscriptionProducer producer;
    private final SuppressibleRealtimeDataHandler rtdHandler;
    private final RealtimeDataProvider rtdProvider;
    private final OutputStream outputStream;
    private final OutputStream errStream;
    private final Scanner inputScanner;

    @Autowired
    public ShellCommandHandler(RestClient restClient, ObjectFactory<UserCredentials> credentialsFactory, AuthenticationTokenCache authTokenCache, SubscriptionManager manager, SuppressibleRealtimeDataHandler rtdHandler, SubscriptionProducer producer, RealtimeDataProvider rtdProvider) {
        this.restClient = restClient;
        this.credentialsFactory = credentialsFactory;
        this.authTokenCache = authTokenCache;
        this.manager = manager;
        this.outputStream = System.out;
        this.errStream = System.err;
        this.inputScanner = new Scanner(System.in);
        this.rtdHandler = rtdHandler;
        this.producer = producer;
        this.rtdProvider = rtdProvider;
    }

    @ShellMethod(value="Shows list of active subscriptions.", key={"list-subscriptions"})
    public void listSubscriptions(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Following subscriptions are active for specified credentials");
        try {
            String token = this.obtainAuthToken(username, password);
            List subscriptionsFromServer = this.restClient.getListOfSubscriptions(token, sourceId);
            this.printMessage(subscriptionsFromServer.size() + " subscriptions" + (subscriptionsFromServer.size() == 1 ? "" : "s") + " found.");
            if (detailed.booleanValue()) {
                subscriptionsFromServer.forEach(s -> this.printMessage("\t" + s.toString() + System.lineSeparator()));
            } else {
                subscriptionsFromServer.stream().map(s -> "\t" + s.getProducerId()).forEach(arg_0 -> this.printMessage(arg_0));
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'list' command: {}", (Throwable)e);
            this.printError("Unable to retrieve a list of subscriptions from server");
        }
        Set activeSubscriptions = this.manager.getAllSubscriptions();
        this.printMessage("Following subscriptions are active within the current client session");
        this.printMessage(activeSubscriptions.size() + " subscriptions" + (activeSubscriptions.size() == 1 ? "" : "s") + " found.");
        for (String producerId : activeSubscriptions) {
            Subscription subscription = this.manager.getSubscription(producerId);
            this.printMessage(subscription.toString());
        }
    }

    @ShellMethod(value="Shows list of sources.", key={"list-sources"})
    public void listSources(@ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Sources configured in the system.");
        try {
            String token = this.obtainAuthToken(username, password);
            List sources = this.restClient.getSources(token);
            this.printMessage(sources.size() + " sources" + (sources.size() == 1 ? "" : "s") + " found.");
            if (detailed.booleanValue()) {
                sources.forEach(s -> this.printMessage("\t" + s.toString() + System.lineSeparator()));
            } else {
                sources.stream().map(s -> "\t" + s.getSourceId()).forEach(arg_0 -> this.printMessage(arg_0));
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'list-sources' command: {}", (Throwable)e);
            this.printError("Unable to retrieve a list of sources from server");
        }
    }

    @ShellMethod(value="Shows a source details.", key={"get-source"})
    public void getSource(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Source configured in the system.");
        try {
            String token = this.obtainAuthToken(username, password);
            Source source = this.restClient.getSource(token, sourceId);
            if (detailed.booleanValue()) {
                this.printMessage("\t" + source.toString() + System.lineSeparator());
            } else {
                this.printMessage("\t" + source.getSourceId() + System.lineSeparator());
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'get-source' command: {}", (Throwable)e);
            this.printError("Unable to retrieve the source from server");
        }
    }

    @ShellMethod(value="Shows list of producers.", key={"list-producers"})
    public void listProducers(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Producers configured in the system.");
        try {
            String token = this.obtainAuthToken(username, password);
            List producers = this.restClient.getProducers(token, sourceId);
            this.printMessage(producers.size() + " producers" + (producers.size() == 1 ? "" : "s") + " found.");
            if (detailed.booleanValue()) {
                producers.forEach(s -> this.printMessage("\t" + s.toString() + System.lineSeparator()));
            } else {
                producers.stream().map(s -> "\t" + s.getProducerId()).forEach(arg_0 -> this.printMessage(arg_0));
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'list-producers' command: {}", (Throwable)e);
            this.printError("Unable to retrieve a list of producers from server");
        }
    }

    @ShellMethod(value="Shows a producer details.", key={"get-producer"})
    public void getProducer(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-pr", "--producer-id"}) String producerId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Producer configured in the system.");
        try {
            String token = this.obtainAuthToken(username, password);
            Producer producer = this.restClient.getProducer(token, sourceId, producerId);
            if (detailed.booleanValue()) {
                this.printMessage("\t" + producer.toString() + System.lineSeparator());
            } else {
                this.printMessage("\t" + producer.getSourceId() + System.lineSeparator());
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'get-producer' command: {}", (Throwable)e);
            this.printError("Unable to retrieve the producer from server");
        }
    }

    @ShellMethod(value="Shows the dictionaries for a producer.", key={"get-dictionary"})
    public void getDictionary(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-pr", "--producer-id"}) String producerId, @ShellOption(value={"-l", "--locale"}) String locale, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Dictionary associated with Producer: " + producerId + " in locale: " + locale);
        try {
            String token = this.obtainAuthToken(username, password);
            Dictionary dictionary = this.restClient.getDictionary(token, sourceId, producerId, locale);
            if (detailed.booleanValue()) {
                this.printMessage("\t" + dictionary.toString() + System.lineSeparator());
            } else {
                this.printMessage("\t" + dictionary.getDescription() + System.lineSeparator());
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'get-producer' command: {}", (Throwable)e);
            this.printError("Unable to retrieve the producer from server");
        }
    }

    @ShellMethod(value="Shows the dimension data for a source.", key={"get-dimension-data"})
    public void getDimensionData(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-dim", "--dimension-data-name"}) String dimensionDataName, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password, @ShellOption(value={"-d", "--detailed"}) Boolean detailed) {
        this.printMessage("Dimension data associated with Source: " + sourceId);
        try {
            String token = this.obtainAuthToken(username, password);
            DimensionData dimensionData = this.restClient.getDimensionData(token, sourceId, dimensionDataName);
            if (detailed.booleanValue()) {
                this.printMessage("\t" + dimensionData.toString() + System.lineSeparator());
            } else {
                this.printMessage("\t" + dimensionData.getDimensions().toString() + System.lineSeparator());
            }
        }
        catch (RestClientException e) {
            LOGGER.error("Exception while handling 'get-dimension-data' command: {}", (Throwable)e);
            this.printError("Unable to retrieve the dimension data from server");
        }
    }

    @ShellMethod(value="Subscribes for realtime data.", key={"subscribe"})
    public void subscribeForRealtimeData(@ShellOption(value={"-src", "--source-id"}) String sourceId, @ShellOption(value={"-pr", "--producer-id"}) String producerId, @ShellOption(value={"-st", "--stream-type"}) StreamType streamType, @ShellOption(value={"-t", "--tenant-id"}, defaultValue="0") String tenantId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password) {
        try {
            String token = this.obtainAuthToken(username, password);
            Filter dimensionFilter = new Filter();
            dimensionFilter.setName("routingServiceName");
            dimensionFilter.getFilters().add("");
            Filter measureFilter = new Filter();
            measureFilter.setName("measure");
            measureFilter.getFilters().add("");
            SubscriptionRequest request = new SubscriptionRequest();
            request.setProducerId(producerId);
            request.setSourceId(sourceId);
            request.setStreamType(streamType.toString());
            request.setTenantId(tenantId);
            request.setTransport("websocket");
            request.setUserName(username);
            request.getDimensionFilters().add(dimensionFilter);
            request.getMeasureFilters().add(measureFilter);
            SubscriptionResponse response = this.restClient.subscribeForRealtimeData(token, request);
            LOGGER.debug("Successfully subscribed for '{}' stream provided by '{}' from the '{}'", new Object[]{streamType, producerId, sourceId});
            if (!this.rtdProvider.isAlive()) {
                this.rtdProvider.connect(response.getEndpoint(), (RealtimeDataHandler)this.rtdHandler);
                LOGGER.debug("Successfully connected to '{}'", (Object)response.getEndpoint());
            }
            Subscription subscription = new Subscription();
            subscription.setProducer(response.getProducer());
            subscription.setProducerId(response.getProducerId());
            subscription.setSource(response.getSource());
            subscription.setSourceId(response.getSourceId());
            subscription.setStreamType(response.getStreamType());
            subscription.setTransport(response.getTransport());
            subscription.setEndpoint(response.getEndpoint());
            subscription.setGuid(response.getGuid());
            subscription.setRtdProvider(this.rtdProvider);
            this.printMessage("Subscription:" + subscription);
            this.manager.associate(response.getProducerId(), subscription);
            this.printMessage(ANNOUNCEMENT);
            this.rtdHandler.suppress(false);
            this.producer.sendSubscribeRequest(this.obtainAuthToken(username, password), subscription);
            this.inputScanner.next();
            this.rtdHandler.suppress(true);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while handling 'subscribe' command: {}", (Throwable)e);
            this.printError(e.getMessage());
        }
    }

    @ShellMethod(value="Unsubscribe from realtime data.", key={"unsubscribe"})
    public void unsubscribeForRealtimeData(@ShellOption(value={"-pr", "--producer-id"}) String producerId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password) {
        try {
            LOGGER.trace("try sendUnsubscribeRequest from " + producerId + " ...");
            Subscription subscription = this.manager.getSubscription(producerId);
            if (subscription == null) {
                this.printError("Subscription matching the specified criteria was not found");
                return;
            }
            this.printMessage("\t Sending unsubscribe message to Producer over WebSocket");
            String token = this.obtainAuthToken(username, password);
            this.producer.sendUnsubscribeRequest(token, subscription);
            this.printMessage("\t Sending unsubscribe message to REST interface");
            this.restClient.unsubscribeFromRealtimeData(token, subscription.getSourceId(), subscription.getProducerId());
            this.printMessage("Successfully unsubscribed from producer " + producerId);
            this.manager.dissociate(producerId);
            Set allSubscriptions = this.manager.getAllSubscriptions();
            if (allSubscriptions.size() == 0) {
                subscription.getRtdDataProvider().disconnect();
            }
        }
        catch (RealtimeDataProviderException e) {
            LOGGER.error("Exception while sending WebSocket unsubscription request", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while handling 'unsubscribe' command:", (Throwable)e);
        }
    }

    @ShellMethod(value="Sends pumpup request for specified measure.", key={"pumpup"})
    public void pumpup(@ShellOption(value={"-pr", "--producer-id"}) String producerId, @ShellOption(value={"-u", "--username"}) String username, @ShellOption(value={"-p", "--password"}) String password) {
        try {
            Subscription subscription = this.manager.getSubscription(producerId);
            if (subscription != null) {
                this.producer.sendPumpupRequest(this.obtainAuthToken(username, password), subscription);
                this.printMessage("Successfully sent pumpup request for producerId: " + producerId);
                LOGGER.info("Successfully sent pumpup request for producerId: {} ", (Object)producerId);
            } else {
                this.printError("Subscription not found");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while handling 'pumpup' command: {}", (Throwable)e);
            this.printError(e.getMessage());
        }
    }

    @ShellMethod(value="Resumes a realtime data streaming for all active subscriptions", key={"resume"})
    public void resume() {
        if (!this.manager.getAllSubscriptions().isEmpty()) {
            this.rtdHandler.suppress(false);
            this.printMessage(ANNOUNCEMENT);
            this.inputScanner.next();
            this.rtdHandler.suppress(true);
        } else {
            this.printError("There are no active subscriptions");
        }
    }

    private String obtainAuthToken(String username, String password) {
        UserCredentials credentials = (UserCredentials)this.credentialsFactory.getObject();
        credentials.setUsername(username);
        credentials.setPassword(password);
        return this.authTokenCache.getToken(credentials);
    }

    private void printMessage(String text) {
        this.printMessageToStream(text, this.outputStream);
    }

    private void printError(String text) {
        this.printMessageToStream(text, this.errStream);
    }

    private void printMessageToStream(String text, OutputStream stream) {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            try {
                if (!StringUtils.endsWith((CharSequence)text, (CharSequence)System.lineSeparator())) {
                    text = (String)text + System.lineSeparator();
                }
                stream.write(((String)text).getBytes());
            }
            catch (IOException e) {
                LOGGER.error("Unable to output message", (Throwable)e);
            }
        }
    }
}

