/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.websocket;

import com.avaya.oceanalytics.openinterface.websocketclient.subscription.HeartbeatGenerator;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.DelegatingWebsocketHandler;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataHandler;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProvider;
import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProviderException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;

@Component
@Scope(value="singleton")
public class WebSocketRtdProvider
implements RealtimeDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketRtdProvider.class);
    private static final String SSL_CONTEXT_KEY = "org.apache.tomcat.websocket.SSL_CONTEXT";
    private static final int CONNECTION_TIME_LIMIT = 10;
    public static final int DELAY = 5000;
    public static final int PERIOD = 8000;
    private final StandardWebSocketClient socket;
    private WebSocketSession session;
    private HeartbeatGenerator heartbeatGenerator;
    private Timer timer;
    private final AtomicBoolean isHeartbeatOn = new AtomicBoolean(false);

    @Autowired
    public WebSocketRtdProvider(SSLContext sslContext) {
        this.socket = new StandardWebSocketClient();
        HashMap<String, SSLContext> userProperties = new HashMap<String, SSLContext>();
        userProperties.put(SSL_CONTEXT_KEY, sslContext);
        this.socket.setUserProperties(userProperties);
    }

    public void connect(String endpointUri, RealtimeDataHandler rtdHandler) {
        DelegatingWebsocketHandler webSocketHandler = new DelegatingWebsocketHandler();
        webSocketHandler.setRtdHandler(rtdHandler);
        ListenableFuture webSessionFuture = this.socket.doHandshake((WebSocketHandler)webSocketHandler, endpointUri, new Object[0]);
        try {
            this.session = (WebSocketSession)webSessionFuture.get(10L, TimeUnit.MINUTES);
            this.startHeartbeat();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RealtimeDataProviderException("Unable to establish websocket connection", (Throwable)e);
        }
    }

    public void startHeartbeat() {
        if (!this.isHeartbeatOn.get()) {
            this.heartbeatGenerator = new HeartbeatGenerator();
            this.heartbeatGenerator.setSession(this.session);
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)this.heartbeatGenerator, 5000L, 8000L);
            this.isHeartbeatOn.set(true);
            LOGGER.info("Starting to send heartbeats to the WebSocket.");
        }
    }

    public void stopHeartbeat() {
        if (this.isHeartbeatOn.get()) {
            this.timer.cancel();
            this.isHeartbeatOn.set(false);
            LOGGER.info("Stopping heartbeats to the WebSocket.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String message) {
        if (this.session == null) {
            throw new RealtimeDataProviderException("Websocket is not connected");
        }
        try {
            WebSocketSession webSocketSession = this.session;
            synchronized (webSocketSession) {
                this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
        }
        catch (IOException e) {
            throw new RealtimeDataProviderException("Unable to send message to websocket", (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.session != null) {
            try {
                this.stopHeartbeat();
                this.session.close(CloseStatus.NORMAL);
            }
            catch (IOException e) {
                LOGGER.error("Error while disconnecting the websocket", (Throwable)e);
            }
        }
    }

    public boolean isAlive() {
        if (this.session == null) {
            return false;
        }
        return this.session.isOpen();
    }
}

