/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient;

import com.avaya.oceanalytics.openinterface.websocketclient.websocket.SuppressibleRealtimeDataHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsoleMessagePrinter
implements SuppressibleRealtimeDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleMessagePrinter.class);
    private final AtomicBoolean isQuiet = new AtomicBoolean(false);
    private final OutputStream outputStream = System.out;
    private final ObjectMapper mapper;

    @Autowired
    public ConsoleMessagePrinter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void handle(String message) {
        LOGGER.info(message);
        if (!this.isQuiet.get()) {
            try {
                Object json = this.mapper.readValue(message, Object.class);
                String prettyJson = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json) + System.lineSeparator();
                this.outputStream.write(prettyJson.getBytes());
            }
            catch (IOException e) {
                LOGGER.error("Unable to output realtime data", (Throwable)e);
            }
        }
    }

    public void suppress(boolean quiet) {
        this.isQuiet.set(quiet);
    }

    public boolean isSuppressed() {
        return this.isQuiet.get();
    }
}

