/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import com.avaya.oceanalytics.openinterface.websocketclient.websocket.RealtimeDataProviderException;
import java.io.IOException;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class HeartbeatGenerator
extends TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatGenerator.class);
    public static final String HEARTBEAT = "--heartbeat--";
    private WebSocketSession session;

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.session == null) {
            throw new RealtimeDataProviderException("Websocket is not connected. Cannot send heartbeat to WebSocket.");
        }
        try {
            WebSocketSession webSocketSession = this.session;
            synchronized (webSocketSession) {
                LOGGER.info("Sending heartbeat to WebSocket");
                this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)HEARTBEAT));
            }
        }
        catch (IOException e) {
            throw new RealtimeDataProviderException("Unable to send heartbeat to WebSocket", (Throwable)e);
        }
    }
}

