package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.Objects;

/**
 * DimensionDataPayload
 */

public class DimensionDataPayload  implements Serializable {
  private static final long serialVersionUID = 1L;

  private String name = null;
  private String type = null;
  private String value = null;

  public DimensionDataPayload name(String name) {
    this.name = name;
    return this;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DimensionDataPayload type(String type) {
    this.type = type;
    return this;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public DimensionDataPayload value(String value) {
    this.value = value;
    return this;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DimensionDataPayload dimensionDataPayload = (DimensionDataPayload) o;
    return Objects.equals(this.name, dimensionDataPayload.name) &&
        Objects.equals(this.type, dimensionDataPayload.type) &&
        Objects.equals(this.value, dimensionDataPayload.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DimensionDataPayload {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

