package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * DimensionDataRow
 */

public class DimensionDataRow  implements Serializable {
  private static final long serialVersionUID = 1L;

  private List<DimensionDataPayload> row = new ArrayList<>();

  public DimensionDataRow row(List<DimensionDataPayload> row) {
    this.row = row;
    return this;
  }

  public DimensionDataRow addRowItem(DimensionDataPayload rowItem) {
    this.row.add(rowItem);
    return this;
  }

  public List<DimensionDataPayload> getRow() {
    return row;
  }

  public void setRow(List<DimensionDataPayload> row) {
    this.row = row;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DimensionDataRow dimensionDataRow = (DimensionDataRow) o;
    return Objects.equals(this.row, dimensionDataRow.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(row);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DimensionDataRow {\n");
    
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

