/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents generic filter.
 * 
 * @author seprokof
 *
 */
public class Filter implements Serializable {
    private static final long serialVersionUID = -1234452353601685656L;

    private String name;
    private final List<String> filters = new ArrayList<String>();

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("name", name).append("filters", filters).build();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getFilters() {
        return filters;
    }

}
