/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.util.Arrays;

/**
 * Represents type on measure stream.
 * 
 * @author seprokof
 *
 */
public enum StreamType {

    SOD("SoD"), MW("MW");

    private String caption;

    private StreamType(String caption) {
        this.caption = caption;
    }

    @Override
    public String toString() {
        return this.caption;
    }

    /**
     * Retrieves enumeration constant associated with given string representation.
     * 
     * @param streamType
     *            string representation
     * @return enumeration constant or <code>null</code> if no associated constant found
     */
    public static StreamType fromString(String streamType) {
        return Arrays.stream(StreamType.values()).filter(s -> s.caption.equalsIgnoreCase(streamType)).findFirst()
                .orElse(null);
    }

}
