/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.websocket;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class DelegatingWebsocketHandler extends TextWebSocketHandler {

    private static final String HEARTBEAT = "--heartbeat--";
    private RealtimeDataHandler rtdHandler;

    public void setRtdHandler(RealtimeDataHandler rtdHandler) {
        this.rtdHandler = rtdHandler;
    }


    @Override
    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = message.getPayload();

        // filter unnecessary messages
        if (StringUtils.isNotBlank(payload) && !HEARTBEAT.equalsIgnoreCase(payload)) {
            rtdHandler.handle(payload);
        }
    }
}
