/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.encryption;

/**
 * Provides encryption and decryption capabilities.
 * 
 * @author seprokof
 *
 */
public interface StringEncryptor {

    /**
     * Performs encryption of specified value.
     * 
     * @param plainValue
     *            value to encrypt
     * @return encrypted value
     */
    String encrypt(String plainValue);

    /**
     * Performs decryption of specified value.
     * 
     * @param encryptedValue
     *            value to decrypt
     * @return decrypted value
     */
    String decrypt(String encryptedValue);

}
