/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.websocket;

/**
 * Represents issues occurred while interacting with realtime data provider.
 * 
 * @author seprokof
 *
 */
public class RealtimeDataProviderException extends RuntimeException {
    private static final long serialVersionUID = 7853139727918469579L;

    /**
     * Creates new data provider exception based on specified message and cause.
     * 
     * @param message
     *            associated message for this exception
     * @param cause
     *            associated cause for this exception
     */
    public RealtimeDataProviderException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates new data provider exception based on specified message.
     * 
     * @param message
     *            associated message for this exception
     */
    public RealtimeDataProviderException(String message) {
        super(message);
    }

}
