package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.Objects;

/**
 * Translation
 */
public class Translation implements Serializable {
  private static final long serialVersionUID = 1L;

  private String name = null;
  private TranslatedPayload translatedPayload = null;

  public Translation name(String name) {
    this.name = name;
    return this;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Translation translatedPayload(TranslatedPayload translatedPayload) {
    this.translatedPayload = translatedPayload;
    return this;
  }

  public TranslatedPayload getTranslatedPayload() {
    return translatedPayload;
  }

  public void setTranslatedPayload(TranslatedPayload translatedPayload) {
    this.translatedPayload = translatedPayload;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Translation translation = (Translation) o;
    return Objects.equals(this.name, translation.name) &&
        Objects.equals(this.translatedPayload, translation.translatedPayload);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, translatedPayload);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Translation {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    translatedPayload: ").append(toIndentedString(translatedPayload)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

