/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.websocket;


/**
 * Represents provider which will supply realtime measure data.
 * 
 * @author seprokof
 *
 */
public interface RealtimeDataProvider {

    /**
     * Establishes a connection to the data source.
     * 
     * @param endpointUri
     *            uri of endpoint to connect
     * @param rtdHandler
     *            realtime data handler which will be used to handle incoming realtime data
     */
    void connect(String endpointUri, RealtimeDataHandler rtdHandler);

    /**
     * Sends specified request to data provider.
     * 
     * @param request
     *            the request to send. Implementations could transform request according their internal logic
     */
    void send(String request);

    /**
     *  Disconnect an existing connection to the data source.
     *
     */
    void disconnect();

    /**
     * Start sending heartbeats to the WebSocket interface
     */
    void startHeartbeat();

    /**
     * Stop sending heartbeats tothe WebSocket interface
     */
    void stopHeartbeat();

    boolean isAlive();

}
