/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.*;
import org.mockito.MockitoAnnotations;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import static org.junit.Assert.*;

/**
 * Test cases for the {@link ConsoleMessagePrinter} class.
 *
 * @author Ivan Kovalev
 */

public class TestConsoleMessagePrinter {

    private static final ByteArrayOutputStream OUTPUT = new ByteArrayOutputStream();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static final String INPUT_MESSAGE = "{\"dimension\":{\"routingServiceName\":\"Service.Automation\"},\"realtimeData\":{\"contactsAtAgent\":1,"
            + "\"alerting\":1},\"sendPumpupRequest\":false,\"pumpupComplete\":false,\"heartbeat\":false}";
    private static final String FORMATTED_INPUT_MESSAGE = "{" + System.lineSeparator() + "  \"dimension\" : {"
            + System.lineSeparator() + "    \"routingServiceName\" : \"Service.Automation\"" + System.lineSeparator()
            + "  }," + System.lineSeparator() + "  \"realtimeData\" : {" + System.lineSeparator()
            + "    \"contactsAtAgent\" : 1," + System.lineSeparator() + "    \"alerting\" : 1" + System.lineSeparator()
            + "  }," + System.lineSeparator() + "  \"sendPumpupRequest\" : false," + System.lineSeparator() + "  "
            + "\"pumpupComplete\" : false," + System.lineSeparator() + "  \"heartbeat\" : false"
            + System.lineSeparator() + "}" + System.lineSeparator();

    private static final String INCORRECT_MESSAGE = "{";

    private ConsoleMessagePrinter consoleMessagePrinter;

    @BeforeClass
    public static void init() {
        System.setOut(new PrintStream(OUTPUT));
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);
        consoleMessagePrinter = new ConsoleMessagePrinter(MAPPER);
    }

    @After
    public void cleanup() {
        OUTPUT.reset();
    }

    @AfterClass
    public static void destroy() {
        System.setOut(System.out);
    }

    @Test
    public void testIsSuppressed() {
        assertFalse(consoleMessagePrinter.isSuppressed());
    }

    @Test
    public void testSuppress() {
        consoleMessagePrinter.suppress(true);
        assertTrue(consoleMessagePrinter.isSuppressed());
        consoleMessagePrinter.suppress(false);
        assertFalse(consoleMessagePrinter.isSuppressed());
    }

    @Test
    public void testHandle() {
        consoleMessagePrinter.handle(INPUT_MESSAGE);
        assertFalse(OUTPUT.toString().isEmpty());
        assertEquals(FORMATTED_INPUT_MESSAGE, OUTPUT.toString());
    }

    @Test
    public void testHandle_IncorrectMessage() {
        consoleMessagePrinter.handle(INCORRECT_MESSAGE);
        assertTrue(OUTPUT.toString().isEmpty());
    }

    @Test
    public void testHandle_Suppressed() {
        consoleMessagePrinter.suppress(true);
        consoleMessagePrinter.handle(INPUT_MESSAGE);
        assertTrue(OUTPUT.toString().isEmpty());
    }
}
