/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient;

import com.avaya.oceanalytics.openinterface.websocketclient.auth.AuthenticationResponse;
import com.avaya.oceanalytics.openinterface.websocketclient.auth.AuthenticationToken;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.when;

/**
 * Test cases for the {@link RestClient} class.
 *
 * @author Ivan Kovalev
 *
 */
public class TestRestClient {

    private RestClient restClient;

    private static final String HOSTNAME = "127.0.0.1";
    private static final Integer PORT = 8443;
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";



    @Mock
    private RestTemplate restTemplate;
    @Mock
    private AuthenticationToken authToken;
    @Mock
    private AuthenticationResponse authenticationResponse;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);
        restClient = new RestClient(restTemplate,HOSTNAME,PORT);
    }

    @Test
    public void testAuthentication() {
        when(restTemplate.getForObject(anyString(),eq(AuthenticationResponse.class))).thenReturn(authenticationResponse);
        when(authenticationResponse.getToken()).thenReturn(authToken);
        AuthenticationToken tokenFromResponse = restClient.authenticate(USERNAME,PASSWORD);
        assertEquals(authToken,tokenFromResponse);
    }

    @Test(expected = RestClientException.class)
    public void testAuthentication_RestClientException() {
        when(restTemplate.getForObject(anyString(),eq(AuthenticationResponse.class)))
                .thenThrow(new RestClientResponseException("Oooops",404,null,null,null,null));
        restClient.authenticate(USERNAME,PASSWORD);
    }

}
