/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.auth;

import com.avaya.oceanalytics.openinterface.websocketclient.encryption.Base64StringEncryptor;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
/**
 * Test cases for the {@link UserCredentials} class.
 *
 * @author Ivan Kovalev
 *
 */
public class TestUserCredential {

    @Spy
    private Base64StringEncryptor encryptor;
    private UserCredentials credentials;

    @Before
    public void startup() {
        MockitoAnnotations.initMocks(this);
        credentials = new UserCredentials();
        credentials.setEncryptor(encryptor);
    }

    @Test
    public void testPassword_EncryptionDecryption() {
        String password = "password";
        credentials.setPassword(password);
        verify(encryptor, times(1)).encrypt(eq(password));
        assertEquals(password, credentials.getPassword());
        verify(encryptor, times(1)).decrypt(anyString());
    }


}
