package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Dictionary
 */

public class Dictionary implements Serializable {
  private static final long serialVersionUID = 1L;

  private String sourceId = null;
  private String producerId = null;
  private String producerName = null;
  private String locale = null;
  private String version = null;
  private String description = null;
  private List<Translation> translations = new ArrayList<>();

  public Dictionary sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }

  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  public Dictionary producerId(String producerId) {
    this.producerId = producerId;
    return this;
  }

  public String getProducerId() {
    return producerId;
  }

  public void setProducerId(String producerId) {
    this.producerId = producerId;
  }

  public Dictionary producerName(String producerName) {
    this.producerName = producerName;
    return this;
  }

  public String getProducerName() {
    return producerName;
  }

  public void setProducerName(String producerName) {
    this.producerName = producerName;
  }

  public Dictionary locale(String locale) {
    this.locale = locale;
    return this;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public Dictionary version(String version) {
    this.version = version;
    return this;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public Dictionary description(String description) {
    this.description = description;
    return this;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Dictionary translations(List<Translation> translations) {
    this.translations = translations;
    return this;
  }

  public Dictionary addTranslationsItem(Translation translationsItem) {
    this.translations.add(translationsItem);
    return this;
  }

  public List<Translation> getTranslations() {
    return translations;
  }

  public void setTranslations(List<Translation> translations) {
    this.translations = translations;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Dictionary dictionary = (Dictionary) o;
    return Objects.equals(this.sourceId, dictionary.sourceId) &&
        Objects.equals(this.producerId, dictionary.producerId) &&
        Objects.equals(this.producerName, dictionary.producerName) &&
        Objects.equals(this.locale, dictionary.locale) &&
        Objects.equals(this.version, dictionary.version) &&
        Objects.equals(this.description, dictionary.description) &&
        Objects.equals(this.translations, dictionary.translations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceId, producerId, producerName, locale, version, description, translations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Dictionary {\n");
    
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("    producerId: ").append(toIndentedString(producerId)).append("\n");
    sb.append("    producerName: ").append(toIndentedString(producerName)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    translations: ").append(toIndentedString(translations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

