/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */
package com.avaya.oceanalytics.openinterface.websocketclient.encryption;

import org.apache.commons.lang3.StringUtils;

import java.util.Base64;

/**
 * Implementation of string encryptor based on Base64 encoding.
 * 
 * @author seprokof
 *
 */
public class Base64StringEncryptor implements StringEncryptor {

    @Override
    public String encrypt(String plainValue) {
        return StringUtils.isNotEmpty(plainValue) ? Base64.getEncoder().encodeToString(plainValue.getBytes())
                : plainValue;
    }

    @Override
    public String decrypt(String encryptedValue) {
        return StringUtils.isNotEmpty(encryptedValue) ? new String(Base64.getDecoder().decode(encryptedValue))
                : encryptedValue;
    }

}
