package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Producer
 */

public class Producer implements Serializable {
  private static final long serialVersionUID = 1L;

  private String sourceId = null;
  private String producerId = null;
  private String producerName = null;
  private String streamType = null;
  private String description = null;
  private String version = null;
  private List<Dimension> dimensions = new ArrayList<>();
  private List<Measure> measures = new ArrayList<>();
  private List<String> locales = new ArrayList<>();

  public Producer sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }

  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  public Producer producerId(String producerId) {
    this.producerId = producerId;
    return this;
  }

  public String getProducerId() {
    return producerId;
  }

  public void setProducerId(String producerId) {
    this.producerId = producerId;
  }

  public Producer producerName(String producerName) {
    this.producerName = producerName;
    return this;
  }

  public String getProducerName() {
    return producerName;
  }

  public void setProducerName(String producerName) {
    this.producerName = producerName;
  }

  public Producer streamType(String streamType) {
    this.streamType = streamType;
    return this;
  }

  public String getStreamType() {
    return streamType;
  }

  public void setStreamType(String streamType) {
    this.streamType = streamType;
  }

  public Producer description(String description) {
    this.description = description;
    return this;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Producer version(String version) {
    this.version = version;
    return this;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public Producer dimensions(List<Dimension> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  public Producer addDimensionsItem(Dimension dimensionsItem) {
    this.dimensions.add(dimensionsItem);
    return this;
  }

  public List<Dimension> getDimensions() {
    return dimensions;
  }

  public void setDimensions(List<Dimension> dimensions) {
    this.dimensions = dimensions;
  }

  public Producer measures(List<Measure> measures) {
    this.measures = measures;
    return this;
  }

  public Producer addMeasuresItem(Measure measuresItem) {
    this.measures.add(measuresItem);
    return this;
  }

  public List<Measure> getMeasures() {
    return measures;
  }

  public void setMeasures(List<Measure> measures) {
    this.measures = measures;
  }

  public Producer locales(List<String> locales) {
    this.locales = locales;
    return this;
  }

  public Producer addLocalesItem(String localesItem) {
    this.locales.add(localesItem);
    return this;
  }

  public List<String> getLocales() {
    return locales;
  }

  public void setLocales(List<String> locales) {
    this.locales = locales;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Producer producer = (Producer) o;
    return Objects.equals(this.sourceId, producer.sourceId) &&
        Objects.equals(this.producerId, producer.producerId) &&
        Objects.equals(this.producerName, producer.producerName) &&
        Objects.equals(this.streamType, producer.streamType) &&
        Objects.equals(this.description, producer.description) &&
        Objects.equals(this.version, producer.version) &&
        Objects.equals(this.dimensions, producer.dimensions) &&
        Objects.equals(this.measures, producer.measures) &&
        Objects.equals(this.locales, producer.locales);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceId, producerId, producerName, streamType, description, version, dimensions, measures, locales);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Producer {\n");
    
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("    producerId: ").append(toIndentedString(producerId)).append("\n");
    sb.append("    producerName: ").append(toIndentedString(producerName)).append("\n");
    sb.append("    streamType: ").append(toIndentedString(streamType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    dimensions: ").append(toIndentedString(dimensions)).append("\n");
    sb.append("    measures: ").append(toIndentedString(measures)).append("\n");
    sb.append("    locales: ").append(toIndentedString(locales)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

