/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents subscription request to Open Interfaces REST API. Followed by {@link SubscriptionResponse}.
 * 
 * @author seprokof
 *
 */
public class SubscriptionRequest implements Serializable {
    private static final long serialVersionUID = 8621508459418271554L;

    private String sourceId;
    private String producerId;
    private String streamType;
    private String transport;
    private String tenantId;
    private String userName;
    private final List<Filter> dimensionFilters = new ArrayList<Filter>();
    private final List<Filter> measureFilters = new ArrayList<Filter>();

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("sourceId", sourceId).append("producerId", producerId)
                .append("streamType", streamType).append("transport", transport).append("tenantId", tenantId)
                .append("userName", userName).append("dimensionFilters", dimensionFilters)
                .append("measureFilters", measureFilters).build();
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getProducerId() {
        return producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getStreamType() {
        return streamType;
    }

    public void setStreamType(String streamType) {
        this.streamType = streamType;
    }

    public String getTransport() {
        return transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<Filter> getDimensionFilters() {
        return dimensionFilters;
    }

    public List<Filter> getMeasureFilters() {
        return measureFilters;
    }

}
