/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.websocket;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

import java.lang.reflect.Method;

import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

/**
 * Test cases for the {@link DelegatingWebsocketHandler} class.
 *
 * @author Ivan Kovalev
 *
 */
public class TestDelegatingWebsocketHandler {

    private static final TextMessage interestingMessage = new TextMessage("Message");
    private static final TextMessage notInterestingMessageHeartbeat = new TextMessage("--heartbeat--");
    private static final TextMessage notInterestingBlankMessage = new TextMessage("");

    @Mock
    private RealtimeDataHandler rtdHandler;
    @Mock
    private WebSocketSession session;

    private DelegatingWebsocketHandler websocketHandler;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks(this);
        websocketHandler = new DelegatingWebsocketHandler();
        websocketHandler.setRtdHandler(rtdHandler);
    }

    @Test
    public void testHandleTextMessage_interestingMessage() throws Exception {
        Method handleTextMessageMethod = DelegatingWebsocketHandler.class.getDeclaredMethod("handleTextMessage", WebSocketSession.class, TextMessage.class);
        handleTextMessageMethod.setAccessible(true);
        handleTextMessageMethod.invoke(websocketHandler,session,interestingMessage);
        verify(rtdHandler,times(1)).handle(interestingMessage.getPayload());
    }

    @Test
    public void testHandleTextMessage_notInterestingMessageHeartbeat() throws Exception {
        Method handleTextMessageMethod = DelegatingWebsocketHandler.class.getDeclaredMethod("handleTextMessage", WebSocketSession.class, TextMessage.class);
        handleTextMessageMethod.setAccessible(true);
        handleTextMessageMethod.invoke(websocketHandler,session,notInterestingMessageHeartbeat);
        verify(rtdHandler,times(0)).handle(notInterestingMessageHeartbeat.getPayload());
    }

    @Test
    public void testHandleTextMessage_notInterestingBlankMessage() throws Exception {
        Method handleTextMessageMethod = DelegatingWebsocketHandler.class.getDeclaredMethod("handleTextMessage", WebSocketSession.class, TextMessage.class);
        handleTextMessageMethod.setAccessible(true);
        handleTextMessageMethod.invoke(websocketHandler,session, notInterestingBlankMessage);
        verify(rtdHandler,times(0)).handle(notInterestingBlankMessage.getPayload());
    }
}
