package com.avaya.oceanalytics.openinterface.websocketclient.subscription;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * DimensionData
 */

public class DimensionData  implements Serializable {
  private static final long serialVersionUID = 1L;

  private String sourceId = null;
  private String producerId = null;
  private String producerName = null;
  private String dataType = null;
  private String version = null;
  private String tenantId = null;
  private List<Dimension> dimensions = new ArrayList<>();
  private List<DimensionDataRow> table = new ArrayList<>();

  public DimensionData sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }

  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  public DimensionData producerId(String producerId) {
    this.producerId = producerId;
    return this;
  }

  public String getProducerId() {
    return producerId;
  }

  public void setProducerId(String producerId) {
    this.producerId = producerId;
  }

  public DimensionData producerName(String producerName) {
    this.producerName = producerName;
    return this;
  }

  public String getProducerName() {
    return producerName;
  }

  public void setProducerName(String producerName) {
    this.producerName = producerName;
  }

  public DimensionData dataType(String dataType) {
    this.dataType = dataType;
    return this;
  }

  public String getDataType() {
    return dataType;
  }

  public void setDataType(String dataType) {
    this.dataType = dataType;
  }

  public DimensionData version(String version) {
    this.version = version;
    return this;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public DimensionData tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public DimensionData dimensions(List<Dimension> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  public DimensionData addDimensionsItem(Dimension dimensionsItem) {
    this.dimensions.add(dimensionsItem);
    return this;
  }

  public List<Dimension> getDimensions() {
    return dimensions;
  }

  public void setDimensions(List<Dimension> dimensions) {
    this.dimensions = dimensions;
  }

  public DimensionData table(List<DimensionDataRow> table) {
    this.table = table;
    return this;
  }

  public DimensionData addTableItem(DimensionDataRow tableItem) {
    this.table.add(tableItem);
    return this;
  }

  public List<DimensionDataRow> getTable() {
    return table;
  }

  public void setTable(List<DimensionDataRow> table) {
    this.table = table;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DimensionData dimensionData = (DimensionData) o;
    return Objects.equals(this.sourceId, dimensionData.sourceId) &&
        Objects.equals(this.producerId, dimensionData.producerId) &&
        Objects.equals(this.producerName, dimensionData.producerName) &&
        Objects.equals(this.dataType, dimensionData.dataType) &&
        Objects.equals(this.version, dimensionData.version) &&
        Objects.equals(this.tenantId, dimensionData.tenantId) &&
        Objects.equals(this.dimensions, dimensionData.dimensions) &&
        Objects.equals(this.table, dimensionData.table);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceId, producerId, producerName, dataType, version, tenantId, dimensions, table);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DimensionData {\n");
    
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("    producerId: ").append(toIndentedString(producerId)).append("\n");
    sb.append("    producerName: ").append(toIndentedString(producerName)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    dimensions: ").append(toIndentedString(dimensions)).append("\n");
    sb.append("    table: ").append(toIndentedString(table)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

