/*
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 */

package com.avaya.oceanalytics.openinterface.websocketclient.websocket;

/**
 * Realtime data handler which can be muted on demand.
 * 
 * @author seprokof
 *
 */
public interface SuppressibleRealtimeDataHandler extends RealtimeDataHandler {

    /**
     * Enables and disables output of messages.
     * 
     * @param quiet
     *            indicates if output should be suppressed or no
     */
    void suppress(boolean quiet);

    /**
     * Indicates current state of messages output.
     * 
     * @return <code>true</code> if messages are suppressed, <code>false</code> otherwise
     */
    boolean isSuppressed();

}
