/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.http;

import com.avaya.collaboration.authorization.http.HttpClientProvider;
import com.avaya.collaboration.authorization.modules.SslProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@Singleton
public class HttpClientProviderImpl
implements HttpClientProvider {
    private final SslProvider<SSLContext> sslContextProvider;
    private PoolingHttpClientConnectionManager clientConnectionManager;
    private ScheduledExecutorService staleConnectionAuditService;
    private CloseableHttpClient clientInstance;
    private static final long AUDIT_PERIOD = 45L;
    private static final long INITIAL_DELAY = 5L;
    private static final int TIMEOUT = 30000;

    @Inject
    public HttpClientProviderImpl(SslProvider<SSLContext> sslContextProvider) throws UnknownHostException, KeyManagementException, NoSuchAlgorithmException {
        this.sslContextProvider = sslContextProvider;
        this.initializeConnectionManager();
        this.initializeConnectionManagerAudit();
        this.initializeHttpClient();
    }

    private void initializeConnectionManager() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = this.sslContextProvider.get();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslsf).build();
        this.clientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        this.clientConnectionManager.setMaxTotal(200);
        this.clientConnectionManager.setDefaultMaxPerRoute(30);
    }

    private void initializeConnectionManagerAudit() {
        this.staleConnectionAuditService = Executors.newSingleThreadScheduledExecutor();
        this.staleConnectionAuditService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                HttpClientProviderImpl.this.clientConnectionManager.closeExpiredConnections();
                HttpClientProviderImpl.this.clientConnectionManager.closeIdleConnections(45L, TimeUnit.SECONDS);
            }
        }, 5L, 45L, TimeUnit.SECONDS);
    }

    private void initializeHttpClient() throws UnknownHostException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
        this.clientInstance = HttpClients.custom().setHostnameVerifier(new AllowAllHostnameVerifier()).setConnectionManager(this.clientConnectionManager).setDefaultRequestConfig(requestConfig).build();
    }

    @Override
    public HttpClient getClientIntance() {
        return this.clientInstance;
    }

    @Override
    public void shutDown() throws IOException {
        this.clientInstance.close();
        this.clientConnectionManager.close();
        this.staleConnectionAuditService.shutdown();
    }
}

