/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.impl;

import com.avaya.collaboration.authorization.AccessToken;
import com.avaya.collaboration.authorization.AccessTokenProvider;
import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.HttpResponseException;
import com.avaya.collaboration.authorization.http.HttpClientProvider;
import com.avaya.collaboration.authorization.http.HttpRequestExecutor;
import com.avaya.collaboration.authorization.modules.KeyProvider;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class AccessTokenProviderImpl
implements AccessTokenProvider {
    private final HttpClientProvider clientProvider;
    private final String tokenEndpoint;
    private final String clientId;
    private static final String AUTH_CODE = "code";
    private JWSSigner signer;

    @Inject
    public AccessTokenProviderImpl(HttpClientProvider clientProvider, KeyProvider<RSAPrivateKey> clientPrivateKeyProvider, @Named(value="tokenEndpoint") String tokenEndpoint, @Named(value="clientId") String clientId) throws AuthorizationHelperException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        this.clientProvider = clientProvider;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        RSAPrivateKey aKey = clientPrivateKeyProvider.get();
        this.setJwtSigner(aKey);
    }

    @Override
    public AccessToken getAccessToken() throws AuthorizationHelperException, HttpResponseException {
        String clientCredentials = this.buildSignedJwt(this.buildJwtClaimsSet(this.clientId, this.clientId));
        try {
            OAuthClientRequest tokenRequest = OAuthClientRequest.tokenLocation(this.tokenEndpoint).setGrantType(GrantType.CLIENT_CREDENTIALS).setParameter("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer").setParameter("client_assertion", clientCredentials).buildBodyMessage();
            tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
            return this.getTokenResponse(tokenRequest);
        }
        catch (OAuthSystemException exception) {
            throw new AuthorizationHelperException("Caught exception while building token request: ", exception);
        }
    }

    @Override
    public AccessToken getAccessToken(List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        String clientCredentials = this.buildSignedJwt(this.buildJwtClaimsSet(this.clientId, this.clientId));
        try {
            if (scopes != null && scopes.size() > 0 && !scopes.contains(null) && !scopes.contains("")) {
                String scope = StringUtils.join(scopes, " ");
                OAuthClientRequest tokenRequest = OAuthClientRequest.tokenLocation(this.tokenEndpoint).setGrantType(GrantType.CLIENT_CREDENTIALS).setParameter("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer").setParameter("client_assertion", clientCredentials).setScope(scope).buildBodyMessage();
                tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
                return this.getTokenResponse(tokenRequest);
            }
            throw new AuthorizationHelperException("Requested scopes are empty.");
        }
        catch (OAuthSystemException exception) {
            throw new AuthorizationHelperException("Caught exception while building token request: ", exception);
        }
    }

    @Override
    public AccessToken getAccessTokenForUser(ServletRequest servletRequest) throws AuthorizationHelperException, HttpResponseException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String authCode = servletRequest.getParameter(AUTH_CODE);
        String clientCredentials = this.buildSignedJwt(this.buildJwtClaimsSet(this.clientId, this.clientId));
        try {
            OAuthClientRequest tokenRequest = OAuthClientRequest.tokenLocation(this.tokenEndpoint).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authCode).setRedirectURI(httpServletRequest.getRequestURL().toString()).setClientId(this.clientId).buildBodyMessage();
            tokenRequest.addHeader("Authorization", "Bearer " + clientCredentials);
            tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
            return this.getTokenResponse(tokenRequest);
        }
        catch (OAuthSystemException exception) {
            throw new AuthorizationHelperException("Caught exception while building token request: ", exception);
        }
    }

    @Override
    public AccessToken getAccessTokenForUser(String userName, String userPassword) throws AuthorizationHelperException, HttpResponseException {
        String clientCredentials = this.buildSignedJwt(this.buildJwtClaimsSet(this.clientId, userName));
        try {
            if (!Strings.isNullOrEmpty(userName) && !Strings.isNullOrEmpty(userPassword)) {
                OAuthClientRequest tokenRequest = OAuthClientRequest.tokenLocation(this.tokenEndpoint).setGrantType(GrantType.PASSWORD).setUsername(userName).setPassword(userPassword).buildBodyMessage();
                tokenRequest.addHeader("Authorization", "Bearer " + clientCredentials);
                tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
                return this.getTokenResponse(tokenRequest);
            }
            throw new AuthorizationHelperException("Username/Password cannot be null/empty.");
        }
        catch (OAuthSystemException exception) {
            throw new AuthorizationHelperException("Caught exception while getting token request: ", exception);
        }
    }

    @Override
    public AccessToken getAccessTokenForUser(String userName, String userPassword, List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        String clientCredentials = this.buildSignedJwt(this.buildJwtClaimsSet(this.clientId, userName));
        try {
            if (!(this.isNullOrEmpty(scopes) || Strings.isNullOrEmpty(userName) || Strings.isNullOrEmpty(userPassword))) {
                String scope = StringUtils.join(scopes, " ");
                OAuthClientRequest tokenRequest = OAuthClientRequest.tokenLocation(this.tokenEndpoint).setGrantType(GrantType.PASSWORD).setUsername(userName).setPassword(userPassword).setScope(scope).buildBodyMessage();
                tokenRequest.addHeader("Authorization", "Bearer " + clientCredentials);
                tokenRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
                return this.getTokenResponse(tokenRequest);
            }
            throw new AuthorizationHelperException("Scopes/Username/Password cannot be null/empty");
        }
        catch (OAuthSystemException exception) {
            throw new AuthorizationHelperException("Caught exception while building token request: ", exception);
        }
    }

    @Override
    public void shutDown() throws AuthorizationHelperException {
        try {
            this.clientProvider.shutDown();
        }
        catch (IOException e) {
            throw new AuthorizationHelperException("Caught exception while shutting down provider: ", e);
        }
    }

    private boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty() || collection.contains(null) || collection.contains("");
    }

    private void setJwtSigner(RSAPrivateKey privateKey) throws AuthorizationHelperException {
        if (privateKey == null) {
            throw new AuthorizationHelperException("Unable to determine signer key for client. Check if the keystore has a valid private key.");
        }
        this.signer = new RSASSASigner(privateKey);
    }

    private HttpPost preparePostRequest(OAuthClientRequest request, Map<String, String> headers) throws AuthorizationHelperException {
        HttpPost postRequest = new HttpPost(request.getLocationUri());
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                postRequest.addHeader(header.getKey(), header.getValue());
            }
        }
        try {
            postRequest.setEntity(new StringEntity(request.getBody()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthorizationHelperException("Caught exception while building POST request: ", e);
        }
        return postRequest;
    }

    private JWTClaimsSet buildJwtClaimsSet(String jwtIssuer, String jwtSubject) {
        return new JWTClaimsSet.Builder().issuer(jwtIssuer).subject(jwtSubject).issueTime(new Date()).jwtID(UUID.randomUUID().toString()).build();
    }

    private String buildSignedJwt(JWTClaimsSet claimsSet) throws AuthorizationHelperException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        try {
            signedJWT.sign(this.signer);
        }
        catch (JOSEException e) {
            throw new AuthorizationHelperException("Caught exception while building JWT request: ", e);
        }
        return signedJWT.serialize();
    }

    private AccessToken getTokenResponse(OAuthClientRequest tokenRequest) throws AuthorizationHelperException, HttpResponseException {
        HttpPost postRequest = this.preparePostRequest(tokenRequest, tokenRequest.getHeaders());
        HttpRequestExecutor requestExecutor = new HttpRequestExecutor(this.clientProvider.getClientIntance(), postRequest);
        return requestExecutor.execute();
    }
}

