/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization;

import com.avaya.collaboration.authorization.AccessToken;
import com.avaya.collaboration.authorization.AccessTokenProvider;
import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.ClientParams;
import com.avaya.collaboration.authorization.HttpResponseException;
import com.avaya.collaboration.authorization.modules.ClientModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.validator.routines.UrlValidator;

public final class AuthorizationClientHelper {
    private AccessTokenProvider tokenProvider;

    private AuthorizationClientHelper() {
    }

    private AccessTokenProvider getAccessTokenProvider() {
        return this.tokenProvider;
    }

    private void initializeAccessTokenProvider(ClientParams clientParams) throws AuthorizationHelperException {
        if (this.tokenProvider == null) {
            Injector injector;
            try {
                injector = Guice.createInjector(new ClientModule(clientParams));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new AuthorizationHelperException("Caught exception while initializing helper: ", e);
            }
            this.tokenProvider = injector.getInstance(AccessTokenProvider.class);
        }
    }

    public AccessToken getAccessToken() throws AuthorizationHelperException, HttpResponseException {
        return this.getAccessTokenProvider().getAccessToken();
    }

    public AccessToken getAccessToken(List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return this.getAccessTokenProvider().getAccessToken(scopes);
    }

    public AccessToken getAccessTokenForUser(ServletRequest servletRequest) throws AuthorizationHelperException, HttpResponseException {
        return this.getAccessTokenProvider().getAccessTokenForUser(servletRequest);
    }

    public AccessToken getAccessTokenForUser(String userName, String userPassword) throws AuthorizationHelperException, HttpResponseException {
        return this.getAccessTokenProvider().getAccessTokenForUser(userName, userPassword);
    }

    public AccessToken getAccessTokenForUser(String userName, String userPassword, List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return this.getAccessTokenProvider().getAccessTokenForUser(userName, userPassword, scopes);
    }

    public void shutdown() throws AuthorizationHelperException {
        this.getAccessTokenProvider().shutDown();
    }

    public static final class Builder {
        private final AuthorizationClientHelper authorizationClientHelper = new AuthorizationClientHelper();
        private final ClientParams clientParams = new ClientParams();

        public ClientIdBuilder tokenEndpoint(String tokenEndpoint) {
            this.clientParams.setTokenEndpoint(tokenEndpoint);
            return new ClientIdBuilder();
        }

        public final class ClientHelperBuilder {
            private ClientHelperBuilder() {
            }

            public AuthorizationClientHelper build() throws AuthorizationHelperException {
                this.validateNotNull(Builder.this.clientParams);
                Builder.this.authorizationClientHelper.initializeAccessTokenProvider(Builder.this.clientParams);
                return Builder.this.authorizationClientHelper;
            }

            private void validateNotNull(ClientParams clientParams) {
                Validate.notNull(clientParams.getClientId(), "Client Id cannot be null.");
                Validate.notNull(clientParams.getKeyAlias(), "Key alias cannot be null");
                Validate.notNull(clientParams.getKeyStore(), "Key store cannot be null");
                Validate.notNull(clientParams.getKeyStorePassword(), "Key store password cannot be null");
                Validate.notNull(clientParams.getTokenEndpoint(), "Token endpoint cannot be null");
                String[] schemes = new String[]{"https"};
                UrlValidator urlValidator = new UrlValidator(schemes, 8L);
                Validate.isTrue(urlValidator.isValid(clientParams.getTokenEndpoint()), "Token endpoint must be a valid URL");
                Validate.notNull(clientParams.getTrustStore(), "Trust store cannot be null");
            }
        }

        public final class TrustStoreBuilder {
            private TrustStoreBuilder() {
            }

            public ClientHelperBuilder trustStore(KeyStore trustStore) {
                Builder.this.clientParams.setTrustStore(trustStore);
                return new ClientHelperBuilder();
            }
        }

        public final class KeyStoreBuilder {
            private KeyStoreBuilder() {
            }

            public TrustStoreBuilder keyStore(KeyStore keyStore, String keyStorePassword, String keyAlias) {
                Builder.this.clientParams.setKeyStore(keyStore);
                Builder.this.clientParams.setKeyStorePassword(keyStorePassword);
                Builder.this.clientParams.setKeyAlias(keyAlias);
                return new TrustStoreBuilder();
            }
        }

        public final class ClientIdBuilder {
            private ClientIdBuilder() {
            }

            public KeyStoreBuilder clientIdentifier(String clientIdentifier) {
                Builder.this.clientParams.setClientId(clientIdentifier);
                return new KeyStoreBuilder();
            }
        }
    }
}

