/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.http;

import com.avaya.collaboration.authorization.AccessToken;
import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.HttpResponseException;
import com.avaya.collaboration.authorization.impl.AccessTokenImpl;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;

public class HttpRequestExecutor {
    private final HttpClient httpClient;
    private final HttpPost httpPost;

    public HttpRequestExecutor(HttpClient httpClient, HttpPost postRequest) {
        this.httpClient = httpClient;
        this.httpPost = postRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AccessToken execute() throws HttpResponseException, AuthorizationHelperException {
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpClient.execute(this.httpPost);){
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String entityContent = EntityUtils.toString(entity);
                Gson tokenGson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                AccessTokenImpl tokenResponse = tokenGson.fromJson(entityContent, AccessTokenImpl.class);
                EntityUtils.consume(entity);
                AccessTokenImpl accessTokenImpl = tokenResponse;
                return accessTokenImpl;
            }
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString(entity, "UTF-8");
            HttpResponseException responseException = new HttpResponseException(response.getStatusLine().getStatusCode(), responseString);
            EntityUtils.consume(entity);
            throw responseException;
        }
        catch (IOException ex) {
            throw new AuthorizationHelperException("Caught exception while executing request: " + ex);
        }
    }
}

