// ///////////////////////////////////////////////////////////////////////////
//
// SampleFilterService.java
//
// Copyright 2018 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/Licence.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.example.servlet;

import com.avaya.customer.example.servlet.api.ChatMessage;
import com.avaya.customer.example.servlet.api.MessageTranscriptV1;
import com.avaya.customer.example.servlet.api.MessageTranscriptV2;
import com.avaya.customer.example.servlet.api.RestFilterAPI;

import com.avaya.customer.example.servlet.api.TranscriptContextAndMessage;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Path;

/**
 * A sample filter service to demonstrate the filter API. The main method (filterChatConversation) simply returns the
 * input messages with "been filtered" appended to each line. Do not edit this class; it should be left as-is to provide
 * a sample. Instead, create a customised class
 */
@Path("filter")
public class SampleFilterService implements RestFilterAPI {

    @Override
    public List<MessageTranscriptV1> filterChatConversationV1(List<MessageTranscriptV1> transcript) {
        List<MessageTranscriptV1> returnedList = new ArrayList<>();
        for (MessageTranscriptV1 chatMessage : transcript) {
            returnedList.add(chatMessage.getFilteredMessage());
        }
        return returnedList;
    }

    @Override
    public TranscriptContextAndMessage filterChatConversationV2(TranscriptContextAndMessage transcript) {
        List<MessageTranscriptV2> returnedList = new ArrayList<>();
        for (MessageTranscriptV2 chatMessage : transcript.getTranscriptMessages()) {
            returnedList.add(chatMessage.getFilteredMessage());
        }
        return new TranscriptContextAndMessage(transcript.getTranscriptContext(), returnedList);
    }

    @Override
    public List<ChatMessage> filterContactChatConversation(List<ChatMessage> transcript) {
        List<ChatMessage> returnedList = new ArrayList<>();
        for (ChatMessage chatMessage : transcript) {
            returnedList.add(new ChatMessage(chatMessage.getSender(), chatMessage.getMessage() + " been filtered",
                    chatMessage.getDate(), chatMessage.getMessageType(), chatMessage.getChannelType()));
        }
        return returnedList;
    }

    @Override
    public String echo(String message) {
        return message;
    }

}
