package com.avaya.customer.example.servlet;

import com.avaya.customer.example.servlet.api.ChatMessage;
import com.avaya.customer.example.servlet.api.EmailTranscript;
import com.avaya.customer.example.servlet.api.MessageTranscriptV1;
import com.avaya.customer.example.servlet.api.MessageTranscriptV2;
import com.avaya.customer.example.servlet.api.RestTranscriptAPI;
import com.avaya.customer.example.servlet.api.TranscriptContextAndMessage;
import com.avaya.customer.example.servlet.utils.FileUtils;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

/**
 * A sample transcript service.
 */
@Path("filter")
public class SampleTranscriptService implements RestTranscriptAPI {

    /**
     * Processes email transcripts
     *
     * @param transcript - EmailTranscript
     * @return 200 OK
     */
    @Override
    public Response processEmailTranscript(EmailTranscript transcript) {
        FileUtils.saveEmailTranscript(transcript);
        return Response.ok().build();
    }

    /**
     * Processes chat/social/sms transcripts
     *
     * @param transcript - list of MessageTranscripts
     * @return list of filtered messages
     */
    @Override
    public List<MessageTranscriptV1> processV1MessageTranscript(List<MessageTranscriptV1> transcript) {
        List<MessageTranscriptV1> returnedList = new ArrayList<>();
        for (MessageTranscriptV1 message : transcript) {
            returnedList.add(message.getFilteredMessage());
        }
        FileUtils.saveMessageTranscript(returnedList);
        return returnedList;
    }

    /**
     * Processes chat/social/sms/async transcripts
     *
     * @param transcript - list of MessageTranscripts
     * @return list of filtered messages
     */
    @Override
    public TranscriptContextAndMessage processV2MessageTranscript(TranscriptContextAndMessage transcript) {
        List<MessageTranscriptV2> returnedList = new ArrayList<>();
        for (MessageTranscriptV2 message : transcript.getTranscriptMessages()) {
            returnedList.add(message.getFilteredMessage());
        }

        TranscriptContextAndMessage transcriptContextAndMessage =
                new TranscriptContextAndMessage(transcript.getTranscriptContext(), returnedList);
        FileUtils.saveTranscriptAndContext(transcriptContextAndMessage);
        return transcriptContextAndMessage;
    }

    /**
     * Processes old chat/social/sms transcripts
     *
     * @param transcript - list of ChatMessages
     * @return list of filtered ChatMessages
     */
    @Override
    public List<ChatMessage> filterContactChatConversation(List<ChatMessage> transcript) {
        List<ChatMessage> returnedList = new ArrayList<>();
        for (ChatMessage chatMessage : transcript) {
            returnedList.add(chatMessage.getFilteredMessage());
        }
        FileUtils.saveChatTranscript(returnedList);
        return returnedList;
    }

    @Override
    public String echo(String message) {
        return message;
    }
}
