// ///////////////////////////////////////////////////////////////////////////
//
// RestFilterAPI.java
//
// Copyright 2018 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/Licence.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.example.servlet.api;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * The interface that is expected for filtering Chat messages.
 */
public interface RestFilterAPI {

    @POST
    @Path("/enhancedtranscript")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<MessageTranscriptV1> filterChatConversationV1(List<MessageTranscriptV1> transcript);

    @POST
    @Path("/v2/enhancedtranscript")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public TranscriptContextAndMessage filterChatConversationV2(TranscriptContextAndMessage transcript);

    @POST
    @Path("/transcript")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<ChatMessage> filterContactChatConversation(List<ChatMessage> transcript);
    /**
     * Endpoint for sanity testing
     */
    @GET
    @Path("/echo/{message}")
    @Produces("text/plain")
    public String echo(@PathParam("message") String message);

}
