package com.avaya.customer.example.servlet.utils;

import java.io.File;

import javax.servlet.ServletContext;

/**
 * Path constants.
 */
public final class Constants {

    /**
     * Web application config path. E.g.: /usr/share/tomcat/temp/CustomerFilterMessages/config/
     */
    public static String       appConfigPath;

    /**
     * Web application properties file path. E.g.:
     * /usr/share/tomcat/temp/CustomerFilterMessages/config/oceana.properties
     */
    public static String       propsPath;

    /**
     * Web application temp dir. E.g.: /usr/share/tomcat/temp/CustomerFilterMessages/
     */
    public static final String messagesTempDir         = System.getProperty("java.io.tmpdir") + "/CustomerFilterMessages/";

    /**
     * Directory to save email transcripts. E.g.: /usr/share/tomcat/temp/CustomerFilterMessages/email/
     */
    public static final String emailTranscriptsDir     = messagesTempDir + "email/";

    /**
     * Directory to save messaging transcripts. E.g.: /usr/share/tomcat/temp/CustomerFilterMessages/messaging/
     */
    public static final String messagingTranscriptsDir = messagesTempDir + "messaging/";

    public Constants(ServletContext context) {
        appConfigPath = messagesTempDir + "config/";
        propsPath = messagesTempDir + "config/oceana.properties";

        new File(appConfigPath).mkdirs();
    }

    private Constants() {
    }
}
