package com.avaya.customer.example.servlet.api;

public class MessageTranscriptV1 extends ChatMessage {

    /** The ID of Customer Contact. */
    private int contactId;

    /** The ID of Customer. */
    private int customerId;

    /** The ID of Chat Request. */
    private String workRequestId;


    public MessageTranscriptV1() {
        // required for JSON conversion
    }

    public MessageTranscriptV1(String sender, int contactId, int customerId, String workRequestId, String message, long date, MessageType messageType,
                               ChannelType channelType, boolean isFallbackMessage) {
        super(sender, message, date, messageType, channelType, isFallbackMessage);
        this.contactId = contactId;
        this.customerId = customerId;
        this.workRequestId = workRequestId;
    }

    public int getContactId() {
        return contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getCustomerId() { return customerId; }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public String getWorkRequestId() {
        return workRequestId;
    }

    public void setWorkRequestId(String workRequestId) {
        this.workRequestId = workRequestId;
    }

    /**
     * @return the filtered transcript message
     */
    @Override
    public MessageTranscriptV1 getFilteredMessage() {
        MessageType type = this.getMessageType();
        return (type == MessageType.PAGEPUSH || type == MessageType.FILETRANSFER) ? this : new MessageTranscriptV1(
                sender,
                contactId,
                customerId,
                workRequestId,
                message + " been filtered",
                date,
                messageType,
                channelType,
                isFallbackMessage
        );
    }

    @Override
    public String toString() {
        return "MessageTranscriptV1 [sender=" + sender + ", contactId=" + contactId +", customerId=" + customerId +", workRequestId=" + workRequestId +"," +
                "message=***" + message + ", date=" + date + ", messageType=" + messageType + ", channelType=" + channelType + ", isFallbackMessage=" + isFallbackMessage + "]";
    }
}
