// ///////////////////////////////////////////////////////////////////////////
//
// ChatMessage.java
//
// Copyright 2018 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/Licence.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.example.servlet.api;

/**
 * Representation of messages sent during a chat for transcript filtering
 */
public class ChatMessage implements Filter {

    /** The display name of the sender. */
    protected String sender;

    /** The message or page push URL. */
    protected String message;

    /** The timestamp of the message. */
    protected long date;

    /** The message type. */
    protected MessageType messageType;

    /** The channel type. */
    protected ChannelType channelType;

    /** The flag shows if fallback message is used instead of actual content. */
    protected boolean isFallbackMessage = false;

    /**
     * Empty constructor for Json
     */
    public ChatMessage() {

    }

    /**
     * Instantiates a new chat message.
     * @param sender the sender
     * @param message the message
     * @param date the date
     * @param messageType the message type
     */
    public ChatMessage(String sender, String message, long date, MessageType messageType, ChannelType channelType) {
        this.sender = sender;
        this.message = message;
        this.date = date;
        this.messageType = messageType;
        this.channelType = channelType;
    }

    /**
     * Instantiates a new chat message.
     * @param sender the sender
     * @param message the message
     * @param date the date
     * @param messageType the message type
     * @param isFallbackMessage the is fallback message
     */
    public ChatMessage(String sender, String message, long date, MessageType messageType, ChannelType channelType, boolean isFallbackMessage) {
        this(sender, message, date, messageType, channelType);
        this.isFallbackMessage = isFallbackMessage;
    }

    /**
     * Gets the sender.
     * @return the sender
     */
    public String getSender() {
        return sender;
    }

    /**
     * Sets the sender.
     * @param sender the new sender
     */
    public void setSender(String sender) {
        this.sender = sender;
    }

    /**
     * Gets the message.
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * Sets the message.
     * @param message the new message
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * Gets the date.
     * @return the date
     */
    public long getDate() {
        return date;
    }

    /**
     * Sets the date.
     * @param date
     */
    public void setDate(long date) {
        this.date = date;
    }

    /**
     * @return the messageType
     */
    public MessageType getMessageType() {
        return messageType;
    }

    /**
     * @param messageType the messageType to set
     */
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    /**
     * @return the channelType
     */
    public ChannelType getChannelType() {
        return channelType;
    }

    /**
     * @param channelType the channelType to set
     */
    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    /**
     * @return the isFallbackMessage
     */
    public boolean getIsFallbackMessage() {
        return isFallbackMessage;
    }

    /**
     * @param isFallbackMessage the isFallbackMessage to set
     */
    public void setIsFallbackMessage(boolean isFallbackMessage) {
        this.isFallbackMessage = isFallbackMessage;
    }

    /**
     * @return the filtered chat message
     */
    @Override
    public ChatMessage getFilteredMessage() {
        String newMessage;

        MessageType type = this.getMessageType();
        if (type != MessageType.PAGEPUSH && type != MessageType.FILETRANSFER) {
            newMessage = message + " been filtered";
        } else {
            newMessage = message;
        }

        return new ChatMessage(sender, newMessage, date, messageType, channelType, isFallbackMessage);
    }

    @Override
    public String toString() {
        return "ChatMessage [sender=" + sender + "," + "message=***" + ", date=" + date + ", messageType=" + messageType
                + ", isFallbackMessage=" + isFallbackMessage + "]";
    }
}
