package com.avaya.customer.example.servlet.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * The interface that is expected for processing transcript messages.
 */
public interface RestTranscriptAPI {

    /**
     * Endpoint for processing Email transcripts
     */
    @POST
    @Path("/transcript/email")
    @Consumes(MediaType.APPLICATION_JSON)
    public Response processEmailTranscript(EmailTranscript transcript);

    /**
     * Endpoint for processing V1 Messaging transcripts.
     */
    @POST
    @Path("/enhancedtranscript")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces (MediaType.APPLICATION_JSON)
    public List<MessageTranscriptV1> processV1MessageTranscript(List<MessageTranscriptV1> transcript);

    /**
     * Endpoint for processing V2 Messaging transcripts.
     */
    @POST
    @Path("/v2/enhancedtranscript")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces (MediaType.APPLICATION_JSON)
    public TranscriptContextAndMessage processV2MessageTranscript(TranscriptContextAndMessage transcript);

    /**
     * Endpoint for processing old chat transcripts.
     */
    @POST
    @Path("/transcript")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<ChatMessage> filterContactChatConversation(List<ChatMessage> transcript);

    /**
     * Endpoint for sanity testing
     */
    @GET
    @Path("/echo/{message}")
    @Produces("text/plain")
    public String echo(@PathParam("message")String message);
}
