
// ///////////////////////////////////////////////////////////////////////////
//
// TestSampleFilter.java
//
// Copyright 2018 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/Licence.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import com.avaya.customer.example.servlet.SampleFilterService;
import com.avaya.customer.example.servlet.api.ChannelType;
import com.avaya.customer.example.servlet.api.ChatMessage;
import com.avaya.customer.example.servlet.api.MessageTranscriptV1;
import com.avaya.customer.example.servlet.api.MessageTranscriptV2;
import com.avaya.customer.example.servlet.api.MessageType;
import com.avaya.customer.example.servlet.api.RestFilterAPI;
import com.avaya.customer.example.servlet.api.TranscriptContext;
import com.avaya.customer.example.servlet.api.TranscriptContextAndMessage;

/**
 * A unit test for the SampleFilterService.
 * @author prowlands
 */
public class TestSampleFilter {
    
    private final RestFilterAPI filter = new SampleFilterService();
    
    private final String customerSender = "C: Auric Goldfinger";
    private final String agentSender = "A: James Bond";
    private final int contactID = 123123;
    private final int customerId = 3123;
    private final String workRequestId = "1231dgdfgf23";
    private final String customerText = "No, Mr Bond. I expect you to die.";
    private final String agentText = "Bond. James Bond.";
    
    @Test
    public void testFilterEcho() throws Exception {
        String testPhrase = "hello";
        Assert.assertEquals(testPhrase,  filter.echo(testPhrase));
    }
    
    @Test
    public void testFilterMessages() {
        MessageTranscriptV1 customerMessage = new MessageTranscriptV1(customerSender, contactID, customerId, workRequestId,customerText, 0, MessageType.NORMAL, ChannelType.CHAT, false);
        MessageTranscriptV1 agentMessage = new MessageTranscriptV1(agentSender,contactID,customerId, workRequestId, agentText, 0, MessageType.NORMAL, ChannelType.CHAT, false);
        
        List<MessageTranscriptV1> original = new ArrayList<>();
        original.add(customerMessage);
        original.add(agentMessage);
        
        List<MessageTranscriptV1> results = filter.filterChatConversationV1(original);
        Assert.assertEquals("The filter service should NOT remove messages!", original.size(), results.size());
        Assert.assertEquals("The filter service should NOT change the order of the messages, and should add 'been filtered' to each message", customerText + " been filtered", results.get(0).getMessage());
        Assert.assertEquals("The filter service should NOT change the order of the messages, and should add 'been filtered' to each message", agentText + " been filtered", results.get(1).getMessage());
        Assert.assertEquals("The channelType should NOT be changed", results.get(0).getChannelType(), original.get(0).getChannelType());
        Assert.assertEquals("The channelType should NOT be changed", results.get(1).getChannelType(), original.get(1).getChannelType());
        
    }

    @Test
    public void testFilterContactIDMessages() {
        ChatMessage customerMessage = new ChatMessage(customerSender, customerText, 0, MessageType.NORMAL, ChannelType.CHAT);
        ChatMessage agentMessage = new ChatMessage(agentSender,agentText, 0, MessageType.NORMAL, ChannelType.CHAT);

        List<ChatMessage> original = new ArrayList<>();
        original.add(customerMessage);
        original.add(agentMessage);

        List<ChatMessage> results = filter.filterContactChatConversation(original);
        Assert.assertEquals("The filter service should NOT remove messages!", original.size(), results.size());
        Assert.assertEquals("The filter service should NOT change the order of the messages, and should add 'been filtered' to each message", customerText + " been filtered", results.get(0).getMessage());
        Assert.assertEquals("The filter service should NOT change the order of the messages, and should add 'been filtered' to each message", agentText + " been filtered", results.get(1).getMessage());

    }
    
    @Test
    public void testV2Filter() {
    	MessageTranscriptV2 customerMessage = new MessageTranscriptV2(customerSender, customerText, 0, MessageType.RICHMEDIAMESSAGE, ChannelType.MESSAGING, "mid-1", "{\"foo\":\"bar\"}", "text/plain", true) ;
    	TranscriptContextAndMessage context = new TranscriptContextAndMessage();
    	context.setTranscriptContext(new TranscriptContext(contactID, customerId, "wrid-1", "conv-1",
                "sneakernet", "user-001", "test-tenant"));
    	context.setTranscriptMessages(Arrays.asList(customerMessage));
    	TranscriptContextAndMessage resultContext = filter.filterChatConversationV2(context);
    	MessageTranscriptV2 filteredMessage = resultContext.getTranscriptMessages().get(0);
    	Assert.assertEquals(contactID, resultContext.getTranscriptContext().getContactId());
    	Assert.assertEquals(customerId, resultContext.getTranscriptContext().getCustomerId());
    	Assert.assertEquals(customerText + " been filtered", filteredMessage.getMessage());
    	Assert.assertTrue(filteredMessage.getIsFallbackMessage());
    }
}
